<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/

/*
Route::get('/', function()
{
	return View::make('hello');
});


Route::post('/api/email/{funcType}', function($funcType)
{
	return Response::json(array('success' => "OK"));
});

*/

////////////////////////////////////////////////////////////////
//  for installer
Route::group(array('prefix' => 'installer'), function()
{
	Route::get('/', function()
	{
		//View::addNamespace('theme', '/path/to/themes/views');
		
		//return Redirect::to('main.html');
		if(!Request::secure()) {
			return Redirect::secure(Request::path());
		}

		return View::make('installer');
	});

	Route::group(['before' => 'check.ssl'], function()
	{
		Route::get('/api/init', 'JobController@initData');

		Route::post('/api/user/login', 'JobInstallerController@doLogin');
		Route::post('/api/system/types', 'SystemController@doGetSystemTypes');
		//Route::group(['before' => 'checkLoginAsInstaller'], function()
		//{
			Route::get('/api/db/{funcType}/{deviceType?}/{brandId?}/{searchStr?}/{targetType?}/{dbType?}', 'UDMLController@doClass');//array('before' => 'checkLogin', 'SystemController@doClass'));			
			Route::post('/api/cloud/search/{deviceType}', 'CloudController@doSearchFromInstaller');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/user/{funcType}', 'JobInstallerController@doUserInfo');
			Route::post('/api/submit/{funcType}', 'JobSubmitController@doClass');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/system/{funcType}/{systemId?}', 'JobInstallerController@doSystemControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
		//});
	});
});

////////////////////////////////////////////////////////////////
//  for urc assistant
Route::group(array('prefix' => 'urcassistant'), function()
{
	Route::get('/', function()
	{
		//View::addNamespace('theme', '/path/to/themes/views');
		
		//return Redirect::to('main.html');
		if(!Request::secure()) {
			return Redirect::secure(Request::path());
		}

		return View::make('assistant');
	});

	Route::group(['before' => 'check.ssl'], function()
	{
		Route::post('/api/user/login', 'JobAssistController@doLogin');
		Route::post('/api/system/types', 'SystemController@doGetSystemTypes');
		Route::post('/api/remote/types', 'SystemController@doGetRemoteTypes');
		//Route::group(['before' => 'checkLoginAsAssistant'], function()
		//{
			Route::get('/api/db/{funcType}/{deviceType?}/{brandId?}/{searchStr?}/{targetType?}/{dbType?}', 'UDMLController@doClass');//array('before' => 'checkLogin', 'SystemController@doClass'));						
			Route::post('/api/user/{funcType}', 'JobAssistController@doUserInfo');
			Route::post('/api/system/{funcType}/{systemId?}', 'JobAssistController@doSystemControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/room/{funcType}/{systemId}/{roomId?}', 'JobAssistController@doRoomControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/device/{funcType}/{roomId}/{deviceId?}', 'JobAssistController@doDeviceControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/btn/{funcType}/{roomId}/{deviceId?}/{buttonId?}', 'JobAssistController@doButtonControl');//array('before' => 'checkLogin', 'SystemController@doClass'));

		//});
	});
});

////////////////////////////////////////////////////////////////
//  for normal user
//Route::group(array('namespace' => 'users'), function()
//{
	Route::get('/', function()
	{
		//View::addNamespace('theme', '/path/to/themes/views');
		
		//return Redirect::to('main.html');
		if(!Request::secure()) {
			return Redirect::secure(Request::path());
		}

		return View::make('main');
	});

	Route::get('/user-login-change', function()
	{
		//View::addNamespace('theme', '/path/to/themes/views');
		
		//return Redirect::to('main.html');
		if(!Request::secure()) {
			return Redirect::secure(Request::path());
		}

		return View::make('user-login-change');
	});

	Route::group(['before' => 'check.ssl'], function()
	{
		Route::post('/api/system/downloadTest', 'DownloadController@doDownloadTest');
		
		Route::post('/api/email/{funcType}', 'EmailController@doClass');
		Route::post('/api/user/{funcType}', 'UserController@doClass');
		Route::post('/api/system/types', 'SystemController@doGetSystemTypes');
		Route::post('/api/system/types_ex', 'SystemController@doGetSystemTypesEx');
		Route::post('/api/remote/types', 'SystemController@doGetRemoteTypes');		
		Route::post('/api/remote/types_ex', 'SystemController@doGetRemoteTypesEx');		
		//Route::group(['before' => 'checkLoginAsUser'], function()
		//{
			Route::post('/api/system/{funcType}/{systemId?}', 'SystemController@doSystemControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/room/{funcType}/{systemId}/{roomId?}', 'SystemController@doRoomControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/device/{funcType}/{roomId}/{deviceId?}', 'SystemController@doDeviceControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/btn/{funcType}/{roomId}/{deviceId?}/{buttonId?}', 'SystemController@doButtonControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/twoway_device/{funcType}/{roomId}/{deviceId?}', 'SystemController@doTwowayDeviceControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/ext_service/{devType}/{funcType}/{systemId}/{roomId?}', 'SystemController@doExternalDevControl');//array('before' => 'checkLogin', 'SystemController@doClass'));

			Route::get('/api/db/{funcType}/{deviceType?}/{brandId?}/{searchStr?}/{targetType?}/{dbType?}', 'UDMLController@doClass');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/download/{funcType}/{systemId?}/{roomId?}', 'DownloadController@doDownload');
		
			Route::post('/api/cloud/search/{deviceType}', 'CloudController@doSearch');//array('before' => 'checkLogin', 'SystemController@doClass'));
			Route::post('/api/cloud/{funcType}', 'CloudController@doFunc');//array('before' => 'checkLogin', 'SystemController@doClass'));

			Route::get('/api/timezone/{funcType}', 'TimezoneController@doClass');
		//});

		//Route::post('/api/system/get/{systemId}', 'SystemController@doGetSystem');//array('before' => 'checkLogin', 'SystemController@doClass'));
		//Route::post('/api/system/destory/{systemId}', 'SystemController@doDestroySystem');//array('before' => 'checkLogin', 'SystemController@doClass'));

		//Route::get('/authors', 'AuthorsController@index');

		Route::get('/file/images/device_icons/{imageName}', 'FileController@doGetDeviceIcons');
		Route::get('/file/help/{fileName}', 'FileController@doGetHelpFiles');
		Route::get('/file/{devType}/{fileName}', 'FileController@doGetDeviceFiles');
		Route::get('/file/twoway/{devType}/{fileName}', 'FileController@doGetTwowayFiles');
		Route::get('/file/{devType}/{macAddr}/info', 'FileController@doGetDeviceInfo');
		Route::post('/file/{devType}/{macAddr}/{dataFileName}', 'DownloadController@doFile');
		Route::post('/file/mobile/{dataFileName}', 'DownloadController@doMobileFile');
		
		Route::post('/cmd/{funcType}', 'CmdController@doFunc');
		Route::post('/csp_api/{funcType}', 'CSPController@doFunc');

		Route::post('/api/dealer/{funcType}', 'DealerController@doClass');
		Route::post('/api/dealer/custom_dev/{funcType}/{customDevId?}', 'DealerDeviceController@doDeviceControl');
		Route::post('/api/dealer/room/{funcType}/{roomId?}', 'DealerSystemController@doRoomControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
		Route::post('/api/dealer/device/{funcType}/{roomId}/{deviceId?}', 'DealerSystemController@doDeviceControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
		Route::post('/api/dealer/btn/{funcType}/{roomId}/{deviceId?}/{buttonId?}', 'DealerSystemController@doButtonControl');//array('before' => 'checkLogin', 'SystemController@doClass'));
			
	});

//});

// =============================================
// CATCH ALL ROUTE =============================
// =============================================
// all routes that are not home or api will be redirected to the frontend
// this allows angular to route them
App::missing(function($exception)
{
	if(!Request::secure()) {
		return Redirect::secure(Request::path());
	}
	return View::make('main');
});



