<?php

use Illuminate\Auth\UserTrait;
use Illuminate\Auth\UserInterface;
use Illuminate\Auth\Reminders\RemindableTrait;
use Illuminate\Auth\Reminders\RemindableInterface;

class User extends Eloquent implements UserInterface, RemindableInterface {

	use UserTrait, RemindableTrait;

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	//protected $connection = 'editor_common';
	protected $table = 'user';

	

	/**
	 * The attributes excluded from the model's JSON form.
	 *
	 * @var array
	 */
	protected $hidden = array('password');//, 'remember_token');

	public function getUserByUsername( $username )
    {
       return $this->where('username', '=', $username)->first();
    }

    public function getUserById( $id )
    {
        return $this->where('id', '=', $id)->first();
    }
}
