<?php

use Illuminate\Auth\UserTrait;
use Illuminate\Auth\UserInterface;
use Illuminate\Auth\Reminders\RemindableTrait;
use Illuminate\Auth\Reminders\RemindableInterface;

class EmailReg extends Eloquent implements UserInterface, RemindableInterface {

	use UserTrait, RemindableTrait;

	//protected $fillable = [ 'email', 'password'];
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'reg_email';

	/**
	 * The attributes excluded from the model's JSON form.
	 *
	 * @var array
	 */
	protected $hidden = array('password');//, 'remember_token');


	public function saveRegEmail($email, $password, $keyValue) {
			
		$regEmail = $this->where('email', '=', $email)->first();
		if($regEmail) {
			$this->where('email', '=', $email)->update(array('password' => $password, 'system_key' => $keyValue));
		}
		else {

			$this->email = $email;				
			$this->password = $password;
			$this->system_key = $keyValue;
			$this->save();
		}
	}

	public static function checkValidUser($email, $tempPassword, $keyValue) {
		$user = EmailReg::where('email', '=', $email)->first();
		if(!$user) {
			return false;
		}

		if(strcasecmp($user->email, $email) ||
			$user->password != $tempPassword ||
			$user->system_key != $keyValue) {
			return false;
		}

		return true;
	}
}
