<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDb2Models extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_db2_models', function(Blueprint $table)
		{
			$table->integer('id')->unsigned()->unique();
			$table->integer('brand_id')->unsigned()->index();
			$table->boolean('major')->default(0);
			$table->tinyInteger('version')->unsigned()->default(0);//0:public, 1:rc, 2:beta, 3: alpha
			$table->string('name', 64)->index();
			$table->integer('target_type')->unsigned()->default(0);
			$table->string('script', 128)->default('');
			$table->text('variables')->default('');
			$table->text('parameter')->default('');
			$table->text('twoway_modules')->default('');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_db2_models');
	}

}
