<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTwowayCategoriesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_twoway_categories', function(Blueprint $table)
		{
			$table->integer('id')->unsigned()->unique();
			$table->string('name', 64)->unique()->index();
			$table->integer('target_type')->unsigned()->default(0);
			$table->string('script', 128)->default('');
			$table->string('parameter', 128)->default('');
			$table->text('twoway_modules')->default('');
		});

		Schema::table('a_twoway_categories', function($t)
		{
			$t->index('id');
			$t->index('name');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_twoway_categories');
	}

}
