<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTwowayDevicesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_twoway_devices', function(Blueprint $table)
		{
			$table->integer('id');
			$table->integer('room_id');
			$table->integer('model_id');//default(-1);			
			$table->string('model', 64)->default('');//default(-1);			
			$table->string('name', 64);
			$table->integer('punch_vol')->default(-1);			
			$table->integer('target_type')->unsigned()->default(3);
			$table->string('target_addr', 128)->default('');	
			$table->text('variables')->default('');
			$table->text('data')->default('');
			$table->text('extra_info')->default('');
		});

		Schema::table('a_twoway_devices', function($t)
		{
			$t->index('id');
			$t->index('room_id');		
			$t->index('target_addr');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_twoway_devices');
	}

}
