<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDownloadTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_download', function(Blueprint $table)
		{
			$table->integer('id')->unsigned();
			$table->tinyInteger('type')->unsigned();
			$table->integer('system_id')->default(-1);
			$table->integer('room_id')->default(-1);
			$table->string('crc', 32)->nullable();
			$table->longText('data')->nullable();
			$table->tinyInteger('link_prg_version')->default(0);
			$table->string('link_crc', 32)->nullable();
			$table->longText('link_data')->nullable();
			$table->timestamps();
		});

		Schema::table('a_download', function($t)
		{
			$t->index('id');
			$t->index('type');
			$t->index('system_id');
			$t->index('room_id');
		});
	}



	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_download');
	}

}
