<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateConDbTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_con_db', function(Blueprint $table)
		{
			$table->integer('id')->unsigned();
			$table->integer('device_id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->boolean('custom')->default(0);
			$table->boolean('press_hold')->default(1);
			$table->tinyInteger('repeat_min')->unsigned()->default(3);
			$table->tinyInteger('repeat_macro')->unsigned()->default(3);
			$table->string('name', 64);
			$table->tinyInteger('type')->default(0);
			$table->text('data');
		});

		Schema::table('a_con_db', function($t)
		{
			$t->index('id');
			$t->index('device_id');
			$t->index('room_id');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_con_db');
	}

}
