<?php

class URCValues {

	const DB_TYPE_NONE = 0;
	const DB_TYPE_IR = 1;
	const DB_TYPE_IP = 2;
	const DB_TYPE_UDP = 3;
	const DB_TYPE_MAC = 4;//twoway

	const TWPWAY_TYPE_NONE = 0;
	const TWOWAY_TYPE_MAC = 1;
	const TWOWAY_TYPE_IP = 2;
	const TWOWAY_TYPE_SERVICE = 4;

	const DEV_TYPE_NORMAL = 0;
	const DEV_TYPE_D_CORE = 1;
	const DEV_TYPE_D_INTERFACE = 2;

	const IR_PREPROGRAM = 0;
	const IR_LEARNED = 1;

	const AUTO_WAIT_OFF = 0;
	const AUTO_WAIT_ON = 1;
	const ETYPE_ACTIVITY = 0;
	const ETYPE_MACRO = 1;
	const POPUP_OFF = 0;
	const POPUP_ON = 1;
	const POPUP_ON_WITH_HELP = 2;

	const ACT_DB = 1;
	const ACT_DELAY = 2;
	const ACT_JUMP = 3;

	const JUMP_DEFALUT = 0;
	const JUMP_DEVICE = 1;

	const JUMP_DEF_MYPAGE = 0;
	const JUMP_DEF_PAGE_PREV = 1;
	const JUMP_DEF_PAGE_NEXT = 2;
	const JUMP_DEF_NAV_PREV = 3;
	const JUMP_DEF_NAV_NEXT = 4;
	const JUMP_DEF_DEV_PREV = 5;
	const JUMP_DEF_DEV_NEXT = 6;
	const JUMP_DEF_MAIN	= 7;

	const UDML_SYS_OFF = 4624;

	const FAV_DELAY_KEEP = 0;
	const FAV_DELAY_CHANGE = 1;

	const DOWN_TYPE_BSTATION = 0;
	const DOWN_TYPE_CLIENT_SYSTEMS = 1;
	const DOWN_TYPE_CLIENT_SYSTEM = 2;
	const DOWN_TYPE_CLIENT_ROOM = 3;

	const BTN_SYSTEM_OFF = 4624;
	const BTN_LABEL_SYSTEM_OFF = 'POWER OFF';
	const BTN_SYSTEM_HELP = 4642;

	const WAIT_SEC = 5;
	const WAIT_SEC_SEARCH = 10;

	const LOGIN_USER = 0;
	const LOGIN_INSTALLER = 1;
	const LOGIN_ASSIST = 2;
	const LOGIN_ADMIN = 3;

	const JOB_INIT = 0;
	const JOB_PROCESS = 1;
	const JOB_READY = 2;
	
	const EDITOR_VER = '1.0.140707.1';

	const UDML_VOL_UP = 275;
	const UDML_VOL_DN = 276;
	const UDML_MUTE = 277;

	const HOME_BTN_OPT_TOP = 0;
	const HOME_BTN_OPT_NAV = 1;

	const MAX_ROOM_CNT = 5;
	const MAX_TWOWAY_MODULE_CNT	= 8;
	const MAX_SAME_TWOWAY_MODULE_CNT = 5;

	const MAX_CUSTOM_DEV_CNT = 100;
	const MAX_TEMPLATE_CNT = 100;
	const MAX_TEMPLATE_VAR_NAME = 64;

	const EXT_SERVICE_AMAZON = 0x0001;

	const DB_MAX_RETRY = 5;
	const DB_ERR_CODE_DEADLOCK = 40001;

	const FUNC_RET_FALSE = 0;
	const FUNC_RET_TRUE = 1;
	const FUNC_RET_DEADLOCK = 1000;


	public static function getMaxTwowayLimit($bstationType, &$maxCnt, &$maxSameCnt) {

		$maxCnt = URCValues::MAX_TWOWAY_MODULE_CNT;
		$maxSameCnt = URCValues::MAX_SAME_TWOWAY_MODULE_CNT;
	}

	public static function getBasestations() {

		return array('MXHP-H500');
		//return array('HCM-C1', 'MXHP-H500');
	}

	public static function getBasestationsEx() {

		$b1 = new stdClass();
		$b1->name = 'MXHP-H500';
		$b1->wired_ir_port = 4;
		$b1->wired_ir_port_all = 1;
		$b1->wireless_ir_port = 1;

		return array($b1);
		//return array('HCM-C1', 'HS-C100');
	}

	public static function isBasestation($devType) {

		switch($devType)
		{
		//case 'HCM-C1':
		//	return true;
		case 'MXHP-H500':
			return true;
		case 'BASESTATIONS':
			return true;
		}

		return false;
	}

	public static function getRemotes() {

		return array('MXHP-R500', 'MXHP-R700');
		//return array('HCM-R1', 'MXHP-R500');
	}

	public static function getRemotesEx() {

		$b1 = new stdClass();
		$b1->name = 'MXHP-R500';
		$b1->type = 'Remote Control';

		$b2 = new stdClass();
		$b2->name = 'MXHP-R700';
		$b2->type = 'Remote Control';

		return array($b1, $b2);
		//return array('HCM-R1', 'HS-R100');
	}

	public static function isRemoteControl($devType) {

		switch($devType)
		{
		//case 'HCM-R1':
		//	return true;
		case 'MXHP-R500':
		case 'MXHP-R700':
			return true;
		case 'CLIENTS':
			return true;
		}

		return false;
	}

	public static function isEntertainmentTwowayDevice($model) {
		if($model == 'SNP-2') {
			return true;
		}

		return false;
	}


	public static function getModelTypeFromId($modelTypeId) {

		switch($modelTypeId)
		{
		//case '00010001':
		//	return 'HCM-C1';			
		//case '00020001':
		//	return 'HCM-R1';
		case '00012001':
			return 'MXHP-H500';
		case '00022001':
			return 'MXHP-R500';
		case '00022003':
			return 'MXHP-R700';
		case '0004f001':
			return 'SNP-2';
		}
		
		return false;
	}

	public static function getModelTypeId($modelType) {

		switch($modelType)
		{
		//case 'HCM-C1':
		//	return '00010001';
		//case 'HCM-R1':
		//	return '00020001';
		case 'MXHP-H500':
			return '00012001';
		case 'MXHP-R500':
			return '00022001';
		case 'MXHP-R700':
			return '00022003';
		case 'SNP-2':
			return '0004f001';
		}

		return false;
	}

	public static function getModelUriId($modelType) {

		switch($modelType)
		{
		//case 'HCM-C1':
		//	return '00010001';
		//case 'HCM-R1':
		//	return '00020001';
		case 'MXHP-H500':
			return '00012001';
		case 'MXHP-R500':
			return '00022001';
		case 'MXHP-R700':
			return '00022003';
		case 'SNP-2':
			return '0004f001';
		case 'CLIENTS':
			return '0002FFFF';
		case 'BASESTATIONS':
			return '0001FFFF';
		}

		return false;
	}

	public static function getModelProvId($modelType) {

		switch($modelType)
		{
		//case 'HCM-C1':
		//	return '00010001';
		//case 'HCM-R1':
		//	return '00020001';
		case 'MXHP-H500':
			return 0x00012001;
		case 'MXHP-R500':
			return 0x00022001;
		case 'MXHP-R700':
			return 0x00022003;
		case 'SNP-2':
			return 0x0004f001;
		}

		return -1;
	}

	public static function genSIPControllerID($modelTypeId, $macData) {

		$randId = StringGenerator::doGen(2, "09");
		return $modelTypeId.'-4354-524C-49'.$randId.'-'.$macData;
	}

	public static function genSIPUserID($macData) {
		
		$randLen = rand(5, 10);
		$randId = StringGenerator::doGen($randLen, "09azAZ");
		return 'UMX'.$randId.'-'.$macData;
	}

	public static function genSIPUserPass() {
		
		$randLen = rand(15, 20);
		return StringGenerator::doGen($randLen);
	}

	public static function isMatchBStationAdminPass($pass) {

		$data = Config::get('editorenv.urcBStationSvrAdminPass');
		$lenstatic = strlen($data) + 3;
		if(strncmp($pass, 'MX_'.$data, $lenstatic) !== 0) {
			//ErrorDebug::write('pass:'.$pass.'      data'.$data);
			return false;
		}

		$len = strlen($pass);
		if($len < 20 || $len > 24) {
			return false;
		}

		return true;
	}

	public static function microtime_gap($microTimeSt, $microTimeEd)
	{
	     list($usecSt, $secSt) = explode(" ", $microTimeSt);
	     $stTime = ((float)$usecSt + (float)$secSt);

	     list($usecEd, $secEd) = explode(" ", $microTimeEd);
	     $edTime = ((float)$usecEd + (float)$secEd);

	     return ($edTime - $stTime);
	}
}


