<?php

require_once('URCUDMLData.php');
require_once('ErrorDebug.php');
require_once('URCValues.php');


class URCTBtnData {

	var $roomId = -1;
	var $deviceId = -1;

	function __construct($roomId, $deviceId) {		
		$this->roomId = $roomId;
		$this->deviceId = $deviceId;
	}

	public function createBtn($text, $auto_wait, $popup, $activity, $macro) {
		
		$urcPage = new URCTPageData($this->roomId, $this->deviceId);
		$pageId = -1;
		$pageBtnIdx = -1;
		if(!$urcPage->getPossibleToAdd($pageId, $pageBtnIdx))
			return URCValues::FUNC_RET_FALSE;

		$new_btn_id = -1;
		
		$jsonActivity = json_encode($activity);
		$jsonMacro = json_encode($macro);

		try
		{
			DB::begintransaction();

			$new_btn_id = $this->getNewBtnId();
			$this->setNewBtnId($new_btn_id+1);
			
			//newDevicedBtn is used instead of newBtn because of using as macro.
			$this->newDeviceBtn($new_btn_id, -1, 
				$pageId, $pageBtnIdx, 
				$auto_wait, URCValues::ETYPE_MACRO, $popup,
				'', $text, 0, $jsonActivity, $jsonMacro);			
			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return array('page_id' => $pageId, 'page_btn_idx' => $pageBtnIdx, 'id' => $new_btn_id);
	}

	public function getMacroFromDevice($conDeviceId) {

		$btn = DB::table('a_t_btns')->where('link_id', '=', $conDeviceId)
			->where('device_id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first(); 

		if(!$btn) {
			return false;
		}

		$activity = json_decode($btn->activity);
		$macro = json_decode($btn->macro);

		return array('auto_wait' => $btn->auto_wait, 'edit_type' => $btn->edit_type, 'popup' => $btn->popup,
			'activity' => $activity, 'macro' => $macro);
	}

	public function delMacroFromDevice($conDeviceId) {

		$btn = DB::table('a_t_btns')->where('link_id', '=', $conDeviceId)
			->where('device_id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first(); 

		if(!$btn) {
			return URCValues::FUNC_RET_FALSE;
		}

		try
		{
			$updatedRow = DB::table('a_t_btns')->where('link_id', '=', $conDeviceId)
				->where('device_id', '=', $this->deviceId)
				->where('room_id', '=', $this->roomId)->update(array('auto_wait' => 1, 'edit_type' => URCValues::ETYPE_MACRO, 'popup' => 0, 'activity' => '', 'macro' => '')); 
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function storeMacroFromDevice($conDeviceId, $auto_wait, $editType, $popup, $activity, $macro) {
		
		$jsonActivity = json_encode($activity);

		try
		{
			if($editType == URCValues::ETYPE_ACTIVITY) {
				
				//ErrorDebug::write('jsonActivity:'.$jsonActivity);
				//ErrorDebug::write('jsonMacro:'.$jsonMacro);

				$updatedRow = DB::table('a_t_btns')->where('link_id', '=', $conDeviceId)
					->where('device_id', '=', $this->deviceId)
					->where('room_id', '=', $this->roomId)->update(array('auto_wait' => $auto_wait, 'edit_type' => $editType, 'popup' => $popup, 'activity' => $jsonActivity, 'macro' => ''));//$jsonMacro)); 
			}
		
			if($editType == URCValues::ETYPE_MACRO){
			
				$jsonMacro = json_encode($macro);

				$updatedRow = DB::table('a_t_btns')->where('link_id', '=', $conDeviceId)
					->where('device_id', '=', $this->deviceId)
					->where('room_id', '=', $this->roomId)->update(array('auto_wait' => $auto_wait, 'edit_type' => $editType, 'popup' => $popup, 'activity' => $jsonActivity, 'macro' => $jsonMacro)); 
			}
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function getMacro($btnId) {

		$btn = DB::table('a_t_btns')->where('id', '=', $btnId)
			->where('device_id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first(); 

		if(!$btn) {
			return false;
		}

		$activity = json_decode($btn->activity);
		$macro = json_decode($btn->macro);

		return array('auto_wait' => $btn->auto_wait, 'edit_type' => $btn->edit_type, 'popup' => $btn->popup,
			'activity' => $activity, 'macro' => $macro);
	}

	public function delMacro($btnId, &$resultType) {

		$btn = DB::table('a_t_btns')->where('id', '=', $btnId)
			->where('device_id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first(); 

		if(!$btn) {
			return URCValues::FUNC_RET_FALSE;
		}

		if($btn->link_id >= 0) {
			
			try
			{
				$updatedRow = DB::table('a_t_btns')->where('id', '=', $btnId)
					->where('device_id', '=', $this->deviceId)
					->where('room_id', '=', $this->roomId)->update(array('auto_wait' => 1, 'edit_type' => URCValues::ETYPE_MACRO, 'popup' => 0, 'activity' => '', 'macro' => '')); 
			}
			catch(\Exception $e) 
			{
				if($e instanceof PDOException) {
					if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
						return URCValues::FUNC_RET_DEADLOCK;
					}
				}
				return URCValues::FUNC_RET_FALSE;	
			}

			$resultType = 1;
		}
		else {

			try
			{
				DB::begintransaction();

				DB::table('a_t_btns')->where('id', '=', $btnId)
					->where('device_id', '=', $this->deviceId)
					->where('room_id', '=', $this->roomId)->delete();

				$this->sortPageData($btn->page_id, $btn->page_btn_idx);

				DB::commit();
			}
			catch(\Exception $e) 
			{
				DB::rollback();
				
				if($e instanceof PDOException) {
					if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
						return URCValues::FUNC_RET_DEADLOCK;
					}
				}
				return URCValues::FUNC_RET_FALSE;	
			}

			$resultType = 2;
		}
	
		return URCValues::FUNC_RET_TRUE;
	}

	public function sortPageData($startPageId, $startBtnIdx) {
		
		//$time_start = microtime(true);

		//faster way

		///for current page

		//btn shift
		DB::statement(
			DB::raw(
				"UPDATE a_t_btns SET page_btn_idx = page_btn_idx -1 WHERE device_id = ? AND room_id = ?
				AND page_id = ? AND page_btn_idx > ?"
			), 

			array($this->deviceId, $this->roomId, $startPageId, $startBtnIdx)
		);
		
		///for next page

		//btn Idx for 0(set page_btn_idx -> -10)
		DB::statement(
			DB::raw(
				"UPDATE a_t_btns SET page_id = page_id -1, page_btn_idx = -10 WHERE device_id = ? AND room_id = ?
				AND page_id > ? AND page_btn_idx = ?"
			), 
			array($this->deviceId, $this->roomId, $startPageId, 0)
		);		

		//btn Idx from 1-5
		DB::statement(
			DB::raw(
				"UPDATE a_t_btns SET page_btn_idx = page_btn_idx -1 WHERE device_id = ? AND room_id = ?
				AND page_id > ? AND page_btn_idx <> ?"
			), 

			array($this->deviceId, $this->roomId, $startPageId, -10)
		);

		//recover for page_btn_idx -> -10
		DB::table('a_t_btns')->where('device_id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->where('page_btn_idx', '=', -10)->update(array('page_btn_idx' => 5));
		
	}

	public function storeMacro($btnId, $auto_wait, $popup, $activity, $macro) {
		
		$jsonActivity = json_encode($activity);
		$jsonMacro = json_encode($macro);
		
		try
		{
			$updatedRow = DB::table('a_t_btns')->where('id', '=', $btnId)
				->where('device_id', '=', $this->deviceId)
				->where('room_id', '=', $this->roomId)->update(array('auto_wait' => $auto_wait, 'edit_type' => URCValues::ETYPE_MACRO, 'popup' => $popup, 'activity' => $jsonActivity, 'macro' => $jsonMacro)); 
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;	
	}
	
	public function getPowerMacro() {

		$btn = DB::table('a_t_btns')->where('device_id', '=', -1)
			->where('room_id', '=', $this->roomId)->first(); 

		if(!$btn) {
			return false;
		}

		$activity = json_decode($btn->activity);
		$macro = json_decode($btn->macro);

		return array('auto_wait' => $btn->auto_wait, 'edit_type' => $btn->edit_type, 'popup' => $btn->popup,
			'activity' => $activity, 'macro' => $macro);
	}

	public function delPowerMacro() {

		$btn = DB::table('a_t_btns')->where('device_id', '=', -1)
			->where('room_id', '=', $this->roomId)->first(); 

		if(!$btn) {
			return URCValues::FUNC_RET_FALSE;	
		}

		try
		{
			$updatedRow = DB::table('a_t_btns')->where('device_id', '=', -1)
				->where('room_id', '=', $this->roomId)->update(array('auto_wait' => 1, 'edit_type' => URCValues::ETYPE_MACRO, 'popup' => 0, 'activity' => '', 'macro' => '')); 
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;	
	}

	public function storePowerMacro($auto_wait, $editType, $popup, $activity, $macro) {
		
		$jsonActivity = json_encode($activity);

		try
		{
			if($editType == URCValues::ETYPE_ACTIVITY) {
			
				//ErrorDebug::write('jsonActivity:'.$jsonActivity);
				//ErrorDebug::write('jsonMacro:'.$jsonMacro);

				$updatedRow = DB::table('a_t_btns')->where('device_id', '=', -1)
					->where('room_id', '=', $this->roomId)->update(array('auto_wait' => $auto_wait, 'edit_type' => $editType, 'popup' => $popup, 'activity' => $jsonActivity, 'macro' => ''));//$jsonMacro)); 

			}
			
			if($editType == URCValues::ETYPE_MACRO){
					
				$jsonMacro = json_encode($macro);

				$updatedRow = DB::table('a_t_btns')->where('device_id', '=', -1)
					->where('room_id', '=', $this->roomId)->update(array('auto_wait' => $auto_wait, 'edit_type' => $editType, 'popup' => $popup, 'activity' => $jsonActivity, 'macro' => $jsonMacro)); 
			}
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}
	
	public function getNewBtnId() {
		
		$device = DB::table('a_t_devices')->where('id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first();
		if(!$device) {
			return -1;
		}

		return $device->btn_id_start;
	}

	public function setNewBtnId($newBtnId) {
		
		DB::table('a_t_devices')->where('id', '=', $this->deviceId)->
			where('room_id', '=', $this->roomId)->update(array('btn_id_start' => $newBtnId));
	}

	protected function isExistBtn($btnId) {

		$existDB = DB::table('a_t_btns')->where('id', '=', $btnId)
			->where('device_id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first(); 
		if($existDB) {
			return 1;
		}

		return 0;
	}

	static public function newDBAction($deviceId, $funcId) {

		$act = (object)array('type' => URCValues::ACT_DB, 'device_id' => $deviceId, 'func' => $funcId);
		return $act;
	}
	
	static public function newJumpAction($type, $value) {

		$act = new stdClass;
		$act->type = URCValues::ACT_JUMP;
		$act->to = array('type' => $type, 'value' => $value);

		return $act;
	}

	static public function newDBMacroJSON($deviceId, $funcId) {

		$macro = array();
		$macro[] = URCTBtnData::newDBAction($deviceId, $funcId);//array('type' => URCValues::ACT_DB, 'device_id' => $deviceId, 'func' => $funcId);
		return json_encode($macro);
	}

	static public function newJumpMacroJSON($type, $value) {

		$macro = array();
		$macro[] = URCTBtnData::newJumpAction($type, $value);
		
		return json_encode($macro);
	}
	
	
	public function newDeviceBtn($btnId, $linkId, $pageId, $pageBtnIdx, $autoWait, $editType, $popup, $imageName, $text, $hiddenOption, &$activityData, &$macroData) {
		DB::table('a_t_btns')->insert(array('id' => $btnId, 'device_id' => $this->deviceId, 'room_id' => $this->roomId,
		 'link_id' => $linkId, 'page_id' => $pageId, 'page_btn_idx' => $pageBtnIdx, 
		 'auto_wait' => $autoWait, 'edit_type' => $editType, 'popup' => $popup,
		 'image_name' => $imageName, 'display_text' => $text, 'hidden_option' => $hiddenOption, 'activity' => $activityData, 'macro' => $macroData));
	}

	public function newBtnQueryDetailEx($btnId, $linkId, $pageId, $pageBtnIdx, $imageName, $text, $hiddenOption, $autoWait, $editType, $popup, &$activity, &$macroData, $hidden, $pageHidden) {

		$query = array('id' => $btnId, 'device_id' => $this->deviceId, 'room_id' => $this->roomId,
		 'link_id' => $linkId, 'page_id' => $pageId, 'page_btn_idx' => $pageBtnIdx, 
		 'auto_wait' => $autoWait, 'edit_type' => $editType, 'popup' => $popup,
		 'image_name' => $imageName, 'display_text' => $text, 'hidden_option' => $hiddenOption, 'activity' => $activity, 'macro' => $macroData,
		 'hidden' => $hidden, 'page_hidden' => $pageHidden);

		return $query;
	}

	public function newBtnQueryDetail($btnId, $pageId, $pageBtnIdx, $text, $hiddenOption, $autoWait, $editType, $popup, &$activity, &$macroData, $hidden, $pageHidden) {

		$query = array('id' => $btnId, 'device_id' => $this->deviceId, 'room_id' => $this->roomId,
		 'link_id' => -1, 'page_id' => $pageId, 'page_btn_idx' => $pageBtnIdx, 
		 'auto_wait' => $autoWait, 'edit_type' => $editType, 'popup' => $popup,
		 'image_name' => '', 'display_text' => $text, 'hidden_option' => $hiddenOption, 'activity' => $activity, 'macro' => $macroData,
		 'hidden' => $hidden, 'page_hidden' => $pageHidden);

		return $query;
	}

	public function newBtnQuery($btnId, $pageId, $pageBtnIdx, $text, $hiddenOption, &$macroData, $hidden, $pageHidden) {

		$activity = '';
		return $this->newBtnQueryDetailEx($btnId, -1, $pageId, $pageBtnIdx, "", $text, $hiddenOption, URCValues::AUTO_WAIT_OFF, URCValues::ETYPE_MACRO,
			URCValues::POPUP_OFF, $activity, $macroData, $hidden, $pageHidden);
	}

	/*
	public function newBtnQuery($btnId, $pageId, $pageBtnIdx, $text, $hiddenOption, &$macroData, $hidden, $pageHidden) {

		$query = array('id' => $btnId, 'device_id' => $this->deviceId, 'room_id' => $this->roomId,
		 'link_id' => -1, 'page_id' => $pageId, 'page_btn_idx' => $pageBtnIdx, 
		 'auto_wait' => URCValues::AUTO_WAIT_OFF, 'edit_type' => URCValues::ETYPE_MACRO, 'popup' => URCValues::POPUP_OFF,
		 'image_name' => '', 'display_text' => $text, 'hidden_option' => $hiddenOption, 'activity' => '', 'macro' => $macroData,
		 'hidden' => $hidden, 'page_hidden' => $pageHidden);

		return $query;
	}
	*/

	public function newBtn($btnId, $pageId, $pageBtnIdx, $text, $hiddenOption, &$macroData) {

		//for doing the bulk query
		$query = $this->newBtnQuery($btnId, $pageId, $pageBtnIdx, $text, $hiddenOption, $macroData, 0, 0);

		DB::table('a_t_btns')->insert($query);
	}

	public function newHardBtn($btnId, $text, &$macroData) {
		
		$this->newBtn($btnId, -1, -1, $text, 0, $macroData);
	}

	public function newSystemOffBtn() {
		$query = array('id' => URCValues::BTN_SYSTEM_OFF, 'device_id' => $this->deviceId, 'room_id' => $this->roomId,
		 'link_id' => -1, 'page_id' => -1, 'page_btn_idx' => -1, 
		 'auto_wait' => URCValues::AUTO_WAIT_ON, 'edit_type' => URCValues::ETYPE_ACTIVITY, 'popup' => URCValues::POPUP_ON,
		 'image_name' => '', 'display_text' => URCValues::BTN_LABEL_SYSTEM_OFF, 'hidden_option' => 0, 'activity' => '', 'macro' => '');

		DB::table('a_t_btns')->insert($query);
	}
}


class URCTPageData {

	//var $btnArray = null;
	var $roomId = -1;
	var $deviceId = -1;
	//var $curPageId = -1;

	function __construct($roomId, $deviceId) {	

		//$btnArray = null;	
		$this->roomId = $roomId;
		$this->deviceId = $deviceId;
		//$this->curPageId = -1;
	}

	public function getNewPageId() {
		
		$device = DB::table('a_t_devices')->where('id', '=', $this->deviceId)
			->where('room_id', '=', $this->roomId)->first();
		if(!$device) {
			return -1;
		}

		return $device->page_id_start;
	}

	public function setNewPageId($newPageId) {
		
		DB::table('a_t_devices')->where('id', '=', $this->deviceId)->
			where('room_id', '=', $this->roomId)->update(array('page_id_start' => $newPageId));
	}

	public function getPossibleToAdd(&$pageId, &$pageBtnIdx) {
		
		//check existing pages
		$urcBtns = DB::table('a_t_btns')->where('device_id', '=', $this->deviceId)-> 
			where('room_id', '=', $this->roomId)->
			whereNotIn('page_id', array(-1))->orderBy('page_id', 'asc')->get();
		
		$arPos = array(-1,-1,-1,-1,-1,-1);
		$curPageId = -2;//-1 is used in db.
		foreach($urcBtns as $btn) {
			
			if($curPageId < 0) {
				$curPageId = $btn->page_id;
				$arPos = array(-1,-1,-1,-1,-1,-1);				
			}
			
			if($btn->page_id == $curPageId) {
				$arPos[$btn->page_btn_idx] = $btn->id;
				continue;
			}
			
			//check
			for($i = 0; $i < 6; $i++) {
				
				if($arPos[$i] >= 0) continue;
				
				$pageId = $curPageId;
				$pageBtnIdx = $i;
				return true;
			}

			$curPageId = $btn->page_id;
			$arPos = array(-1,-1,-1,-1,-1,-1);
			$arPos[$btn->page_btn_idx] = $btn->id;
		}

		//check
		if($curPageId >= 0) {
			for($i = 0; $i < 6; $i++) {
				
				if($arPos[$i] >= 0) continue;
				
				$pageId = $curPageId;
				$pageBtnIdx = $i;
				return true;
			}
		}

		//make new
		$newPageId = $this->getNewPageId();
		$pageId = $newPageId;
		$pageBtnIdx = 0;

		$this->setNewPageId($newPageId+1);

		return true;
	}

}

class URCTDeviceData {

	var $roomId = -1;

	function __construct($roomId) {	
		$this->roomId = $roomId;
	}
	

	public static function isExistVol(&$device) {

		if($device->dev_type == 1) {
			return 0;
		}
		else {
			return 1;
		}

		return 1;
	}

	public function appendPowerOff($deviceId, $addedId) {

		if($addedId < 0)
			return;

		$data = DB::table('a_t_btns')->where('device_id', '=', -1)
			->where('room_id', '=', $this->roomId)->first();

		$activityData = array();
		if(strlen($data->activity) > 0) {
			$activityData = json_decode($data->activity);			
			if(count($activityData) <= 0) {
				$activityData = array();
			}
		}

		$activityData[] = (object)array('device_id' => $deviceId, 'type' => 0, 'func' => $addedId);
		$jsonActivity = json_encode($activityData);

		DB::table('a_t_btns')->where('device_id', '=', -1)
			->where('room_id', '=', $this->roomId)->update(array('activity' => $jsonActivity));
	}
	
	//$target = new stdClass;
	//$target->type = 0;
	//$target->addr = "";
	//$target->port = "";
	//$favOption =  new stdClass;
	//$favOption->enable = 0;
	//$favOption->delay = 100;	
	public function createDevice($username, $name, $category, $brand, $model, $dbType, $modelId, $target, $favOption) {

		//get data
		//extract : repeat{min, macro}, 
		$attr = new stdClass;

		$udmlObj = new URCUDMLData($username, 'dev');
		$udmlData = $udmlObj->getDevice($dbType, $modelId, $target->type);
		if(!$udmlData) {
			return URCValues::FUNC_RET_FALSE;
		}
		
		//ErrorDebug::write($dbType.";".$modelId.";".$target->type);

		$attr->repeat_min = $udmlData['attr']['rpt_min'];
		$attr->repeat_macro = $udmlData['attr']['rpt_cnt'];
		
		if(!isset($target->addr)) {
			$target->addr = '';
		} 

		if($target->type === URCValues::DB_TYPE_IP) {//IP

			if(isset($udmlData['attr']['tcp_udp']) && $udmlData['attr']['tcp_udp'] == 1) {
				$target->type = URCValues::DB_TYPE_UDP;
			}

			$attr->ramp_start = $udmlData['attr']['ramp_st'];
			$attr->ramp_speed = $udmlData['attr']['ramp_sp'];
			$attr->auto_cr = $udmlData['attr']['auto_cr'];
			$attr->con_time = $udmlData['attr']['con_time'];
			$attr->delay_after_send = $udmlData['attr']['delay_after_send'];

			if(!isset($target->port)) {
				$target->port = $udmlData['attr']['port'];
			}
		}

		if(!isset($target->port)) {
			$target->port = 0;
		}
		//ErrorDebug::write(json_encode($udmlData));

		//apply data
		$deviceId = -1;
		try
		{
			DB::begintransaction();
			//create device 
			if(strncmp($model, 'Code# ', 6) == 0) {
				$deviceId = $this->newDevice($name, $category, $brand, 'Code# '.$modelId, -1, $udmlData['meta'], $attr, $favOption, $target, 0);
			}
			else {
				$deviceId = $this->newDevice($name, $category, $brand, $model, -1, $udmlData['meta'], $attr, $favOption, $target, 0);
			}
			if($deviceId < 0) {
				throw new \Exception('Device ID not created');
			}
			//create connected Device 
			$this->newConDevData($deviceId, $udmlData);

			//create keyboard data
			$this->newKeyboardData($deviceId, $udmlData);

			//apply hard buttons and pages
			$this->applyBtns($deviceId, $udmlData);
			//add to main page
			if(!$this->addMainBtn($name, $deviceId, $category)) {
				throw new \Exception('fail to add device button');
			}

			//apply power off
			$addedId = -1;
			if($udmlData['meta']) {
				foreach($udmlData['meta'] as $item) {
					if($item['strid'] == 'POWER_OFF') {
						$addedId = (int)$item['funcid'];
					}
					else if($item['strid'] == 'POWER_TOGGLE') {
						if($addedId < 0) {
							$addedId = (int)$item['funcid'];
						}
					}
				}
			}

			$this->appendPowerOff($deviceId, $addedId);

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		//ErrorDebug::write('create:'.URCValues::microtime_gap($timeTestSt, microtime()));

		return URCValues::FUNC_RET_TRUE;
	}


	public function createCustomDevice(&$deviceData) {
		
		//get data
		//extract : repeat{min, macro}, 
		
		$favOption = new stdClass;
		$favOption->enable = 0;
		$favOption->delay = 400;
		$favOption->enter = 1;

		$jsonDevData = json_encode($deviceData);
		//ErrorDebug::write('createCustom');
		//ErrorDebug::write($jsonDevData);
		
		$device = json_decode($jsonDevData);
		
		$attr = new stdClass;
		$attr->repeat_min = $device->repeat->min;
		$attr->repeat_macro = $device->repeat->macro;
		$attr->con_time = 0;
		if(isset($device->attr->con_time)) {
			$attr->con_time = $device->attr->con_time;
		}

		$metaData = array();
		if(isset($device->meta_pwr_on)) {
			$metaData[] = array('strid' => 'POWER_ON', 'funcid' => $device->meta_pwr_on);
		}
		if(isset($device->meta_pwr_off)) {
			$metaData[] = array('strid' => 'POWER_OFF', 'funcid' => $device->meta_pwr_off);
		}
		if(isset($device->meta_pwr_toggle)) {
			$metaData[] = array('strid' => 'POWER_TOGGLE', 'funcid' => $device->meta_pwr_toggle);
		}
		if(isset($device->meta_in_toggle)) {
			$metaData[] = array('strid' => 'INPUT_TOGGLE', 'funcid' => $device->meta_in_toggle);
		}


		//apply data
		$deviceId = -1;
		try
		{
			DB::begintransaction();

			//create device 
			//$metaData = null;
			$deviceId = $this->newDevice($device->name, $device->category, $device->brand, $device->model, -1, $metaData, $attr, $favOption, $device->target, 0);
			if($deviceId < 0) {
				throw new \Exception('Device ID not created');
			}

			//create connected Device 
			if(isset($device->dbCon)) {
				$this->newCustomConDevData($deviceId, $device->dbCon);
			}

			//create keyboard data
			if(isset($device->dbKey)) {
				$this->newCustomKeyboardData($deviceId, $device->dbKey);
			}

			//apply hard buttons and pages
			$this->applyCustomBtns($deviceId, $device);

			//add to main page
			if(!$this->addMainBtn($device->name, $deviceId, $device->category)) {
				throw new \Exception('fail to add device button');
			}

			//apply power off
			$addedId = -1;
			foreach($metaData as $item) {
				if($item['strid'] == 'POWER_OFF') {
					$addedId = (int)$item['funcid'];
				}
				else if($item['strid'] == 'POWER_TOGGLE') {
					if($addedId < 0) {
						$addedId = (int)$item['funcid'];
					}
				}
			}

			$this->appendPowerOff($deviceId, $addedId);


			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		return URCValues::FUNC_RET_TRUE;
	}

	/*
	public function createTwowayDevice($username, $name, $model, $modelId, $target) {

		
		//create device 
		$attr = new stdClass;

		$udmlObj = new URCUDMLData($username, 'dev');

		$dbType = 0;
		$dbTargetType = URCValues::DB_TYPE_IP;
		switch($model)
		{
		case "SNP-2":
			break;
		default:
			return -1;
		}

		$udmlData = $udmlObj->getDevice($dbType, $modelId, $dbTargetType);
		if($udmlData) {
			$attr->repeat_min = $udmlData['attr']['rpt_min'];
			$attr->repeat_macro = $udmlData['attr']['rpt_cnt'];
		
			if(!isset($target->addr)) {
				$target->addr = '';
			} 
		}
		else {
			$attr->repeat_min = 3;
			$attr->repeat_macro = 3;

			return -1;
		}

		if($dbTargetType === URCValues::DB_TYPE_IP) {//IP

			$attr->ramp_start = $udmlData['attr']['ramp_st'];
			$attr->ramp_speed = $udmlData['attr']['ramp_sp'];
			$attr->auto_cr = $udmlData['attr']['auto_cr'];
			$attr->con_time = $udmlData['attr']['con_time'];
			$attr->delay_after_send = $udmlData['attr']['delay_after_send'];

			if(!isset($target->port)) {
				$target->port = $udmlData['attr']['port'];
			}
		}
		
		$favOption =  new stdClass;
		$favOption->enable = 0;
		$favOption->delay = 100;
		$favOption->enter = 1;

		$deviceId = -1;
		try
		{
			DB::begintransaction();

			//create device 
			$metaData = $udmlData ? $udmlData['meta'] : null;			
			$deviceId = $this->newDevice($name, '', '', $model, $modelId, $metaData, $attr, $favOption, $target, 1);			
			if($deviceId < 0) {
				throw new \Exception('Device ID not created');
			}
	
			if($udmlData) {
				//create connected Device 
				$this->newConDevData($deviceId, $udmlData);

				//create keyboard data
				$this->newKeyboardData($deviceId, $udmlData);
			}

			//apply hard buttons and pages
			//$this->applyBtns($deviceId, $udmlData);

			//add to main page
			if(!$this->addMainBtn($name, $deviceId, $model)) {
				throw new \Exception('fail to add device button');
			}

			//apply power off
			$addedId = -1;
			if($udmlData['meta']) {
				foreach($udmlData['meta'] as $item) {
					if($item['strid'] == 'POWER_OFF') {
						$addedId = (int)$item['funcid'];
					}
					else if($item['strid'] == 'POWER_TOGGLE') {
						if($addedId < 0) {
							$addedId = (int)$item['funcid'];
						}
					}
				}
			}

			$this->appendPowerOff($deviceId, $addedId);

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		return URCValues::FUNC_RET_TRUE;
	}
	*/

	public function destroyDevice($deviceId) {

		try
		{
			DB::begintransaction();

			//delete device 
			DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
				where('id', '=', $deviceId)->delete();
			
			//delete connected Device 
			DB::table('a_t_keys_db')->where('room_id', '=', $this->roomId)->
				where('device_id', '=', $deviceId)->delete();

			//delete keyboard data
			DB::table('a_t_con_db')->where('room_id', '=', $this->roomId)->
				where('device_id', '=', $deviceId)->delete();
			
			DB::table('a_t_btns')->where('room_id', '=', $this->roomId)->
				where('device_id', '=', $deviceId)->delete();

			//delete from main page
			$this->deleteDeviceBtn($deviceId);

			//clear punch info
			$this->clearPunchInfo($deviceId);

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function editDevice($deviceId, $deviceName, $target, $attr) {

		try
		{
			DB::begintransaction();

			//con_time is not set, it is now showed in User side
			if($target->type == URCValues::DB_TYPE_IP ||
				$target->type == URCValues::DB_TYPE_UDP) {
				$updatedRow = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
					where('id', '=', $deviceId)->update(
						array('name' => $deviceName, 'target_type' => $target->type, 'target_addr' => $target->addr, 'target_port' => $target->port,
						'repeat_min' => $attr->repeat_min, 'repeat_macro' => $attr->repeat_macro,
						'ramp_start' => $attr->ramp_start, 'ramp_speed' => $attr->ramp_speed, 'auto_cr' => $attr->auto_cr));
			}
			else {
				$updatedRow = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
					where('id', '=', $deviceId)->update(
						array('name' => $deviceName, 'target_type' => $target->type, 'target_addr' => $target->addr, 'target_port' => $target->port,
						'repeat_min' => $attr->repeat_min, 'repeat_macro' => $attr->repeat_macro));
			}
		
			DB::table('a_t_btns')->where('room_id', '=', $this->roomId)->
				where('link_id', '=', $deviceId)->update(array('display_text' => $deviceName));

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function setFavoriteDevice($deviceId, $favOption, $favDelayOption, $favDelay = 400, $favEnter = 1) {

		$updatedRow = 0;
	
		try {

			if($favDelayOption == URCValues::FAV_DELAY_KEEP) {
		
				$updatedRow = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
					where('id', '=', $deviceId)->update(array('fav_option' => $favOption, 'fav_enter' => $favEnter));			
			}
			else {
				$updatedRow = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
					where('id', '=', $deviceId)->update(array('fav_option' => $favOption, 'fav_delay' => $favDelay, 'fav_enter' => $favEnter));
			}
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		if($updatedRow <= 0)
			URCValues::FUNC_RET_FALSE;

		return URCValues::FUNC_RET_TRUE;
	}

	
	public function getPunchDevice($deviceId) {

		$device = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
				where('id', '=', $deviceId)->first();	

		if(!$device)
			return -1;

		return $device->punch_vol;
	}

	public function setPunchDevice($deviceFrom, $deviceTo) {

		if($deviceFrom == $deviceTo) {
			$deviceFrom = -1;
		}
		
		try
		{
			$updatedRow = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
				where('id', '=', $deviceTo)->update(array('punch_vol' => (int)$deviceFrom));		
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function setPunchDevices($deviceFrom, $deviceTo) {

		$jsonData = json_encode($deviceTo);
		$devices = json_decode($jsonData);

		if(!is_array($devices)) {
			return URCValues::FUNC_RET_FALSE;
		}

		try
		{
			DB::begintransaction();

			foreach($devices as $item) {

				if($item == $deviceFrom) {
					DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
						where('id', '=', $item)->update(array('punch_vol' => -1));
				}
				else {
					DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
						where('id', '=', $item)->update(array('punch_vol' => (int)$deviceFrom));
				}
			}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function newMainDevice() {

		$attr = new stdClass;
		$attr->repeat_min = 3;
		$attr->repeat_macro = 3;

		$target = new stdClass;
		$target->type = 0;
		$target->addr = '';
		$target->port = 0;
		
		$favOption =  new stdClass;
		$favOption->enable = 0;
		$favOption->delay = 100;
		$favOption->enter = 1;

		$metaData = null;
		$deviceId = $this->newDevice("Main", "Main", "", "", -1, $metaData, $attr, $favOption, $target, 0);
		
		return $deviceId;
	}

	public function newDevice($name, $category, $brand, $model, $modelId, &$metaData, &$attr, &$favOption, &$target, $devType) {

		$deviceId = $this->getNewDeviceId();
		if($deviceId < 0)
			return -1;
		$this->setNewDeviceId($deviceId+1);//DB::table('a_rooms')->where('id', '=', $roomId)->update(array('device_id_start' => $deviceId+1));

		//check already exist
		if($this->isExistDevice($deviceId))
			return -1;

		$ramp_start = 100;
		$ramp_speed = 100;
		$auto_cr = 0;	
		$con_time = 0;	
		$delay_after_send = 50;
		switch($target->type) {
		case URCValues::DB_TYPE_IP:
		case URCValues::DB_TYPE_UDP:
		case URCValues::DB_TYPE_MAC:

			$repeat_min = 1;
			$repeat_macro = 1;
			if(isset($attr->repeat_min)) {
				$repeat_min = $attr->repeat_min;
			}
			if(isset($attr->repeat_macro)) {
				$repeat_macro = $attr->repeat_macro;
			}
			if(isset($attr->ramp_start)) {
				$ramp_start = $attr->ramp_start;
			}
			if(isset($attr->ramp_speed)) {
				$ramp_speed = $attr->ramp_speed;
			}
			if(isset($attr->auto_cr)) {
				$auto_cr = $attr->auto_cr;
			}
			if(isset($attr->con_time)) {
				$con_time = $attr->con_time;
			}
			if(isset($attr->delay_after_send)) {
				$delay_after_send = $attr->delay_after_send;
			}
			break;
		//case URCValues::DB_TYPE_IR:
		default:

			$repeat_min = 3;
			$repeat_macro = 3;		
			if(isset($attr->repeat_min)) {
				$repeat_min = $attr->repeat_min;
			}
			if(isset($attr->repeat_macro)) {
				$repeat_macro = $attr->repeat_macro;
			}
			break;
		}

		$metaPwrOn = -1;
		$metaPwrOff = -1;
		$metaPwrToggle = -1;
		$metaInToggle = -1;
		if($metaData) {
			foreach($metaData as $item) {
				if($item['strid'] == 'POWER_ON') {
					$metaPwrOn = $item['funcid'];
				}
				else if($item['strid'] == 'POWER_OFF') {
					$metaPwrOff = $item['funcid'];
				}
				else if($item['strid'] == 'POWER_TOGGLE') {
					$metaPwrToggle = $item['funcid'];
				}
				else if($item['strid'] == 'INPUT_TOGGLE') {
					$metaInToggle = $item['funcid'];
				}
			}
		}

		//ErrorDebug::write('on:'.$metaPwrOn.'off:'.$metaPwrOff.'toggle:'.$metaPwrToggle.'in:'.$metaInToggle);

		//add
		DB::table('a_t_devices')->insert(array('id' => $deviceId, 'room_id' => $this->roomId, 
			'dev_type' => $devType,
			'category' => $category, 'brand' => $brand, 'model' => $model, 'model_id' => $modelId, 'page_id_start' => 0, 'btn_id_start' => 8192,//0x2000 
			'punch_vol' => -1, 'repeat_min' => $repeat_min, 'repeat_macro' => $repeat_macro,
			'ramp_start' => $ramp_start, 'ramp_speed' => $ramp_speed, 'con_time' => $con_time, 'delay_after_send' => $delay_after_send, 
			'fav_option' => $favOption->enable, 'fav_delay' => $favOption->delay, 'fav_enter' => $favOption->enter, 
			'name' => $name, 'target_type' => $target->type, 'target_addr' => $target->addr, 'target_port' => $target->port,
			'auto_cr' => $auto_cr,
			'meta_pwr_on' => $metaPwrOn, 'meta_pwr_off' => $metaPwrOff, 'meta_pwr_toggle' => $metaPwrToggle, 'meta_in_toggle' => $metaInToggle));
		
		return $deviceId;
	}

	public function getNewDeviceId() {
		
		$room = DB::table('a_t_rooms')->where('id', '=', $this->roomId)->first();
		if(!$room) {
			return -1;
		}

		return $room->device_id_start;
	}

	public function setNewDeviceId($newDeviceId) {
		
		DB::table('a_t_rooms')->where('id', '=', $this->roomId)->update(array('device_id_start' => $newDeviceId));
	}

	public function isExistDevice($deviceId) {

		$existDB = DB::table('a_t_devices')->where('id', '=', $deviceId)->
			where('room_id', '=', $this->roomId)->first(); 
		if($existDB) {
			return 1;
		}
		return 0;
	}

	protected function newConDevData($deviceId, $udmlData) {
		
		//for doing the bulk query
		$query = array();
		foreach($udmlData['btns'] as $btn) {

			$query[] = array('id' => (int) $btn['id'], 'device_id' => $deviceId, 'room_id' => $this->roomId, 
				'name' => $btn['caption'], 'type' => URCValues::IR_PREPROGRAM, 'data' => $btn['cmd']);
		}

		if(count($query) > 0) {
			DB::table('a_t_con_db')->insert($query);
		}
	}

	protected function newCustomConDevData($deviceId, $dbCon) {
		
		//for doing the bulk query
		$query = array();
		foreach($dbCon as $func) {

			$query[] = array('id' => (int) $func->id, 'device_id' => $deviceId, 'room_id' => $this->roomId, 
				'name' => $func->name, 'type' => $func->type, 'data' => $func->data);

		}

		if(count($query) > 0) {
			DB::table('a_t_con_db')->insert($query);
		}
	}

	public function getConDevData($deviceId) {

		return DB::table('a_t_con_db')->where('device_id', '=', $deviceId)->
			where('room_id', '=', $this->roomId)->get();
	}

	public function getMetaData($deviceId) {

		$urcDevice = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
			where('id', '=', $deviceId)->first(); 
		if(!$urcDevice) {
			return false;
		}

		return $urcDevice;
	}

	protected function newKeyboardData($deviceId, $udmlData) {

		//for doing the bulk query
		$query = array();
		foreach($udmlData['keys'] as $btn) {

			$query[] = array('id' => $btn['def'], 'device_id' => $deviceId, 'room_id' => $this->roomId, 
				'name' => $btn['caption'], 'type' => URCValues::IR_PREPROGRAM, 'data' => $btn['cmd']);
		}
		if(count($query) > 0) {
			DB::table('a_t_keys_db')->insert($query);
		}
	}

	protected function newCustomKeyboardData($deviceId, $dbKey) {

		//for doing the bulk query
		$query = array();
		foreach($dbKey as $func) {

			$query[] = array('id' => $func->id, 'device_id' => $deviceId, 'room_id' => $this->roomId, 
				'name' => $func->name, 'type' => $func->type, 'data' => $func->data);
		}
		if(count($query) > 0) {
			DB::table('a_t_keys_db')->insert($query);
		}
	}


	public function applyBtns($deviceId, $udmlData) {
		
		if(isset($udmlData['attr']['last_page'])) {

			$urcBtn = new URCTBtnData($this->roomId, $deviceId);
			$btn_id_start = $urcBtn->getNewBtnId();
			$btn_id_start_org = $btn_id_start;

			$conData = $this->getConDevData($deviceId);
		
			$urcPage = new URCTPageData($this->roomId, $deviceId);
			
			//for doing the bulk query
			$query = array();
			foreach($udmlData['btns'] as $btn) {

				$btnId = $btn['id'];
				$macroData = URCTBtnData::newDBMacroJSON($deviceId, (int)$btnId);

				$isHardBtn = URCUDMLData::isHardKeyId($btnId);
				if($isHardBtn) {			
					$query[] = $urcBtn->newBtnQuery($btnId, -1, -1, $btn['caption'], 0, $macroData, 0, 0);
				}

				if(isset($btn['pg_num']) && isset($btn['btn_num'])) {

					$pageId = ((int)$btn['pg_num']) - 1;
					$pageBtnIdx = ((int)$btn['btn_num']) - 1;

					//ErrorDebug::write('lcd'.$pageId.'     '.$pageBtnIdx);				
					$query[] = $urcBtn->newBtnQuery($btn_id_start, $pageId, $pageBtnIdx, $btn['caption'], 0, $macroData, 0, 0);
					$btn_id_start++;
				}
			}

			if(count($query) > 0) {
				DB::table('a_t_btns')->insert($query);
			}

			if($btn_id_start_org != $btn_id_start) {//added

				$new_page_id = $udmlData['attr']['last_page'];
				//ErrorDebug::write('$new_page_id'.$new_page_id);
				$urcPage->setNewPageId($new_page_id);
				$urcBtn->setNewBtnId($btn_id_start);
			}
		}
		else {
		
			$urcBtn = new URCTBtnData($this->roomId, $deviceId);
			$btn_id_start = $urcBtn->getNewBtnId();
			
			$conData = $this->getConDevData($deviceId);
		
			$urcPage = new URCTPageData($this->roomId, $deviceId);
			$pageId = $urcPage->getNewPageId();
			$pageBtnIdx = 0;
			
			//for doing the bulk query
			$query = array();
			foreach($conData as $funcData) {

				$macroData = URCTBtnData::newDBMacroJSON($deviceId, $funcData->id);

				if(URCUDMLData::isHardKeyId($funcData->id)) {			
					$urcBtn->newHardBtn($funcData->id, $funcData->name, $macroData);
				}
				else {
					if($pageBtnIdx >= 6) {
						$pageBtnIdx = 0;
						$pageId++;
					}
					
					$query[] = $urcBtn->newBtnQuery($btn_id_start, $pageId, $pageBtnIdx, $funcData->name, 0, $macroData, 0, 0);
					$btn_id_start++;
					$pageBtnIdx++;
				}
			}

			if(count($query) > 0) {
				DB::table('a_t_btns')->insert($query);
			}

			if($pageBtnIdx > 0)//added
				$urcPage->setNewPageId($pageId+1);
			else
				$urcPage->setNewPageId($pageId);
			
			$urcBtn->setNewBtnId($btn_id_start);
		}
	}

	public function applyCustomBtns($deviceId, &$device) {
		
		//add
		$query = array();

		$urcBtn = new URCTBtnData($this->roomId, $deviceId);
		$btn_id_start = $urcBtn->getNewBtnId();

		$new_page_id = 0;
		foreach($device->pages as $page) {

			if($page->id < 0) {
				foreach($page->btns as $btn) {

					$btnMacro = json_decode($btn->macro);
					foreach($btnMacro as $func) {
						if($func->device_id < 0) {
							$func->device_id = $deviceId;
						}
					}
					$btn->macro = json_encode($btnMacro);
				
					$query[] = $urcBtn->newBtnQuery($btn->id, $page->id, $btn->page_btn_idx, $btn->display_text, $btn->hidden_option, $btn->macro, 0, 0);
				}
			}
			else {
				foreach($page->btns as $btn) {

					$btnMacro = json_decode($btn->macro);
					foreach($btnMacro as $func) {
						if($func->device_id < 0) {
							$func->device_id = $deviceId;
						}
					}
					$btn->macro = json_encode($btnMacro);

					$query[] = $urcBtn->newBtnQuery($btn_id_start, $page->id, $btn->page_btn_idx, $btn->display_text, $btn->hidden_option, $btn->macro, 0, 0);
					$btn_id_start++;
				}

				if($new_page_id <= $page->id) {
					$new_page_id = $page->id + 1;
				}
			}
		}

		if(count($query)) {
			DB::table('a_t_btns')->insert($query);
		}

		//set new btn id
		$urcBtn->setNewBtnId($btn_id_start);

		//apply new page id
		$urcPage = new URCTPageData($this->roomId, $deviceId);
		$urcPage->setNewPageId($new_page_id);

		//ErrorDebug::write('new_page_id'.$new_page_id);
	}


	public function getMainDeviceId() {

		$room = DB::table('a_t_rooms')->where('id', '=', $this->roomId)->first();
		if(!$room)
			return -1;

		return $room->main_device_id;
	}

	public function getDefaultImage($category) {

		$udmlObj = new URCUDMLData('', 'dev');
		return $udmlObj->getDefaultImage($category);
	}

	public function addMainBtn($name, $addedDeviceId, $addedCategory) {

		$mainDevId = $this->getMainDeviceId();
		if($mainDevId < 0)
			return false;

		$urcBtn = new URCTBtnData($this->roomId, $mainDevId);
		$btn_id_start = $urcBtn->getNewBtnId();
		$urcBtn->setNewBtnId($btn_id_start+1);

		$urcPage = new URCTPageData($this->roomId, $mainDevId);

		$pageId = -1;
		$pageBtnIdx = -1;
		if(!$urcPage->getPossibleToAdd($pageId, $pageBtnIdx))
			return false;

		$imageName = $this->getDefaultImage($addedCategory);
		$activityData = '';
		$macroData = '';//URCBtnData::newJumpMacroJSON(URCValues::JUMP_DEVICE, $addedDeviceId);		
		$urcBtn->newDeviceBtn($btn_id_start, $addedDeviceId, 
			$pageId, $pageBtnIdx,
			URCValues::AUTO_WAIT_ON, URCValues::ETYPE_MACRO, URCValues::POPUP_ON, 
			$imageName, $name, 0, $activityData, $macroData);
		
		//$urcPage->saveCurPageBtns();

		
		return true;
	}

	public function addMainBtnForTwowayDevice($name, $addedDeviceId, $model) {

		$mainDevId = $this->getMainDeviceId();
		if($mainDevId < 0)
			return false;

		$urcBtn = new URCTBtnData($this->roomId, $mainDevId);
		$btn_id_start = $urcBtn->getNewBtnId();
		$urcBtn->setNewBtnId($btn_id_start+1);

		$urcPage = new URCTPageData($this->roomId, $mainDevId);

		$pageId = -1;
		$pageBtnIdx = -1;
		if(!$urcPage->getPossibleToAdd($pageId, $pageBtnIdx))
			return false;

		$imageName = '';//$this->getDefaultImage($addedCategory);
		$activityData = '';
		$macroData = '';//URCBtnData::newJumpMacroJSON(URCValues::JUMP_DEVICE, $addedDeviceId);		
		$urcBtn->newDeviceBtn($btn_id_start, $addedDeviceId, 
			$pageId, $pageBtnIdx,
			URCValues::AUTO_WAIT_ON, URCValues::ETYPE_MACRO, URCValues::POPUP_ON, 
			$imageName, $name, 0, $activityData, $macroData);
		
		//$urcPage->saveCurPageBtns();

		
		return true;
	}

	public function deleteDeviceBtn($deviceId) {

		DB::table('a_t_btns')->where('room_id', '=', $this->roomId)->
			where('link_id', '=', $deviceId)->delete();

		return true;
	}

	public function clearPunchInfo($deviceId) {

		DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
			where('punch_vol', '=', $deviceId)->update(array('punch_vol' => -1));		

		//DB::table('a_t_twoway_devices')->where('room_id', '=', $this->roomId)->
		//	where('punch_vol', '=', $deviceId)->update(array('punch_vol' => -1));	
	}

	public function getConDevFuncs($deviceId) {
		$condevs = DB::table('a_t_con_db')->where('room_id', '=', $this->roomId)->
			where('device_id', '=', $deviceId)->get();

		unset($condevs['device_id']);

		return $condevs;
	}

	public function getDevice($deviceId, $isMain) {

		$urcDevice = DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
			where('id', '=', $deviceId)->first(); 
		if(!$urcDevice) {
			return false;
		}

		$urcDevice->exist_vol = URCTDeviceData::isExistVol($urcDevice);

		if($urcDevice->dev_type == 1) {
			
			$deviceObj = new stdClass;
			$deviceObj->name = $urcDevice->name;
			$deviceObj->id = $deviceId;
			$deviceObj->dev_type = $urcDevice->dev_type;

			return $deviceObj;	
		}

		$urcBtns = DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
			where('room_id', '=', $this->roomId)->orderBy('page_id', 'asc')->get();

		$urcConDB = DB::table('a_t_con_db')->where('device_id', '=', $deviceId)-> 
			where('room_id', '=', $this->roomId)->get();

		$urcKeyDB = DB::table('a_t_keys_db')->where('device_id', '=', $deviceId)-> 
			where('room_id', '=', $this->roomId)->get();

		$deviceObj = new stdClass;
		$deviceObj->name = $urcDevice->name;
		$deviceObj->id = $deviceId;
		$deviceObj->dev_type = $urcDevice->dev_type;
		$deviceObj->meta_pwr_on = $urcDevice->meta_pwr_on;
		$deviceObj->meta_pwr_off = $urcDevice->meta_pwr_off;
		$deviceObj->meta_pwr_toggle = $urcDevice->meta_pwr_toggle;
		$deviceObj->meta_in_toggle = $urcDevice->meta_in_toggle;

		$deviceObj->pages = array();	

		if($isMain === false) {
			
			$deviceObj->repeat = new stdClass;
			$deviceObj->repeat->min = $urcDevice->repeat_min;
			$deviceObj->repeat->macro = $urcDevice->repeat_macro;
			if($urcConDB) {
				$deviceObj->dbCon = $urcConDB;
			}
			else {
				$deviceObj->dbCon = array();
			}

			if($urcKeyDB) {
				$deviceObj->dbKey = $urcKeyDB;
			}
			else {
				$deviceObj->dbKey = array();
			}

			$deviceObj->type = $urcDevice->target_type;
			if($deviceObj->type == URCValues::DB_TYPE_IP ||
				$deviceObj->type == URCValues::DB_TYPE_UDP) {

				$deviceObj->ramp = new stdClass;
				$deviceObj->ramp->start = $urcDevice->ramp_start;
				$deviceObj->ramp->speed = $urcDevice->ramp_speed;

				$deviceObj->attr = new stdClass;
				$deviceObj->attr->auto_cr = $urcDevice->auto_cr;
				$deviceObj->attr->con_time = $urcDevice->con_time;
				$deviceObj->attr->delay_after_send = $urcDevice->delay_after_send;
			}
		}

		$pageIdx = 0;
		$pageObj = null;
		$curPageId = -2;//-1 is used in db.
		foreach($urcBtns as $btn) {
			
			if($btn->page_id != $curPageId) {

				$deviceObj->pages[$pageIdx] = new stdClass;
				$pageObj = &$deviceObj->pages[$pageIdx];
				$pageIdx++;

				$pageObj->id = $btn->page_id;
				$pageObj->btns = array();
				
				$curPageId = $btn->page_id;
			}

			if($btn->page_hidden) {
				
				if(!isset($pageObj->page_hidden)) {
					$pageObj->page_hidden = 1;
				}
			}
			else {
				
				if(isset($pageObj->page_hidden)) {
					$pageObj->page_hidden = 0;
				}
			}
			
			unset($btn->page_id);
			unset($btn->page_hidden);			
			$pageObj->btns[] = $btn;
		}

		//ErrorDebug::write('getDevice');
		//ErrorDebug::write(json_encode($deviceObj));

		return $deviceObj;		
	}

	public function getMatchObject(&$arItem, $id) {

		foreach($arItem as $item) {
			if($item->id == $id) {
				return $item;
			}
		}

		return null;
	}

	public function isSameBtn(&$btn1, &$btn2) {

		foreach($btn1 as $key => $val) {
			if($val != $btn2->$key) {
				return false;
			}
		}

		return true;
	}

	public function checkButtonsMatch(&$urcBtns, &$device, &$new_page_id, &$arDelBtn, &$arUpdateBtn, &$arNewBtn, &$arDelDev, &$max_btn_id) {
		
		$new_page_id = 0;
		
		$chkArr = array();
		$chkBtnArr = array();
		foreach($urcBtns as $btn) {			
			$chkArr[$btn->id] = 1;
			$chkBtnArr[$btn->id] = $btn;

			if($max_btn_id < $btn->id) {
				$max_btn_id = $btn->id;
			}
		}

		foreach($device->pages as $page) {

			$appliedId = $new_page_id;
			if($page->id == -1) {//Hard Buttons
				$appliedId = -1;
			}
			else {
				$new_page_id++;			
			}

			$pageHidden = 0;
			if(isset($page->hidden)) {
				$pageHidden = $page->hidden;
			}

			foreach($page->btns as $btn) {

				$btn->page_id = $appliedId;
				$btn->page_hidden = $pageHidden;

				if(!isset($btn->hidden)) {					
					$btn->hidden = 0;
				}
					
				if(!isset($chkArr[$btn->id])) {
					$arNewBtn[] = $btn;
				}
				else if($chkArr[$btn->id] == -1) {
					return false;
				}
				else if($chkArr[$btn->id] != 1) {
					$arNewBtn[] = $btn;
				}
				else {
					if(!$this->isSameBtn($chkBtnArr[$btn->id], $btn)) {
						$arUpdateBtn[] = $btn;
					}
					
					$chkArr[$btn->id] = -1;
				}
			}
		}

		foreach($chkArr as $key => $value) {
			if($value == 1) {
				$arDelBtn[] = $key;

				$btn = $this->getMatchObject($urcBtns, $key);
				if($btn !== null && $btn->link_id >= 0) {
					
					$arDelDev[] = $btn->link_id;
				}
			}
		}

		return true;
	}

	public function storeDevice($deviceId, &$deviceData, $isMain) {
		
		if($isMain) {
			return $this->storeDeviceMain($deviceId, $deviceData);
		}
		else {
			return $this->storeDeviceReal($deviceId, $deviceData);
		}
	}

	public function updateBtnsQuery(&$arBtn) {
	
		$arKeys = array('room_id', 'device_id', 'id', 'page_id', 'page_btn_idx', 
					'display_text', 'hidden_option', 'image_name', 
					'auto_wait', 'edit_type', 'popup', 'activity', 'macro',
					'hidden', 'page_hidden');
		
		$items = array();
		foreach($arBtn as $btn) {

			$items[] = sprintf("(%d,%d,%d,%d,%d,'%s',%d,'%s',%d,%d,%d,'%s','%s',%d,%d) ", 
					$btn->room_id, $btn->device_id, $btn->id, 
					$btn->page_id, $btn->page_btn_idx,
					$btn->display_text, $btn->hidden_option, $btn->image_name, 
					$btn->auto_wait, $btn->edit_type, $btn->popup, $btn->activity, $btn->macro,
					$btn->hidden, $btn->page_hidden);
		}		

		$values = array();
		foreach($arKeys as $keyItem) {
			$values[] = sprintf('%s=VALUES(%s)', $keyItem, $keyItem);
		}

		$strQuery = sprintf("INSERT INTO %s (%s) VALUES %s ON DUPLICATE KEY UPDATE %s", 
			'a_t_btns', implode(",", $arKeys), implode(",", $items), implode(",", $values));
		
		return $strQuery;
	}

	public function storeDeviceMain($deviceId, &$deviceData) {
		
		$jsonDeviceData = json_encode($deviceData);

		//ErrorDebug::write('storeDevice');
		//ErrorDebug::write($jsonDeviceData);
		
		$device = json_decode($jsonDeviceData);
		
		$urcBtns = DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
			where('room_id', '=', $this->roomId)->orderBy('page_id', 'asc')->get();
		
		$max_btn_id = 8192;
	
		$new_page_id = 0;
		$arDelBtn = array();
		$arUpdateBtn = array();
		$arNewBtn = array();
		$arDelDev = array();
		if($this->checkButtonsMatch($urcBtns, $device, $new_page_id, $arDelBtn, $arUpdateBtn, $arNewBtn, $arDelDev, $max_btn_id) === false) {
			return URCValues::FUNC_RET_FALSE;
		}

		if(count($arNewBtn) > 0)
			return URCValues::FUNC_RET_FALSE;
		
		/*
		foreach($arUpdateBtn as $btn) {
			$arDelBtn[] = $btn->id;
			$arNewBtn[] = $btn;
		}
		$arUpdateBtn = array();
		*/
		
		try
		{
			DB::begintransaction();

			//delete
			if(count($arDelBtn) > 0) {

				DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
					where('room_id', '=', $this->roomId)->
					whereIn('id', $arDelBtn)->delete();
			}

			if(count($arDelDev) > 0) {

				//delete buttons in the deleted devices
				DB::table('a_t_btns')->where('room_id', '=', $this->roomId)->
					whereIn('device_id', $arDelDev)->delete();
				//delete devices						
				DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
					whereIn('id', $arDelDev)->delete();
			}

			//update
			if(count($arUpdateBtn) > 0) {

				$query = $this->updateBtnsQuery($arUpdateBtn);
				DB::statement($query);

				/*
				foreach($arUpdateBtn as $btn) {

					DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
						where('room_id', '=', $this->roomId)->
						where('id', '=', $btn->id)->
						update(array('page_id' => $btn->page_id, 'page_btn_idx' => $btn->page_btn_idx, 
							'display_text' => $btn->display_text, 'hidden_option' => $btn->hidden_option, 'image_name' => $btn->image_name, 
							'auto_wait' => $btn->auto_wait, 'edit_type' => $btn->edit_type, 'popup' => $btn->popup, 'activity' => $btn->activity, 'macro' => $btn->macro,
							'hidden' => $btn->hidden, 'page_hidden' => $btn->page_hidden));
				}
				*/
				
				//$dif = microtime(TRUE) - $time;
	 			//ErrorDebug::write('Difff:'.$dif);
			}

			//add
			if(count($arNewBtn) > 0) {
				
				$query = array();

				$urcBtn = new URCTBtnData($this->roomId, $deviceId);
				
				foreach($arNewBtn as $btn) {

					if($btn->page_id < 0) {
						$query[] = $urcBtn->newBtnQueryDetailEx($btn->id, $btn->link_id, $btn->page_id, $btn->page_btn_idx, $btn->image_name, $btn->display_text, $btn->hidden_option, 
							$btn->auto_wait, $btn->edit_type, $btn->popup, $btn->activity, $btn->macro, $btn->hidden, $btn->page_hidden);
					}
					else {
						$query[] = $urcBtn->newBtnQueryDetailEx($btn->id, $btn->link_id, $btn->page_id, $btn->page_btn_idx, $btn->image_name, $btn->display_text, $btn->hidden_option, 
							$btn->auto_wait, $btn->edit_type, $btn->popup, $btn->activity, $btn->macro, $btn->hidden, $btn->page_hidden);
						//$btn_id_start++;
					}

					if($max_btn_id < $btn->id) {
						$max_btn_id = $btn->id;
					}					
				}

				DB::table('a_t_btns')->insert($query);

				//set new btn id
				$max_btn_id++;
				$urcBtn->setNewBtnId($max_btn_id);
			}

			//apply new page id
			$urcPage = new URCTPageData($this->roomId, $deviceId);
			$urcPage->setNewPageId($new_page_id);
			
			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function storeDeviceReal($deviceId, &$deviceData) {
		
		$jsonDeviceData = json_encode($deviceData);

		//ErrorDebug::write('storeDevice');
		//ErrorDebug::write($jsonDeviceData);
		
		$device = json_decode($jsonDeviceData);
		
		$urcBtns = DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
			where('room_id', '=', $this->roomId)->orderBy('page_id', 'asc')->get();
		
		$max_btn_id = 8192;
		
		$new_page_id = 0;
		$arDelBtn = array();
		$arUpdateBtn = array();
		$arNewBtn = array();
		$arDelDev = array();
		if($this->checkButtonsMatch($urcBtns, $device, $new_page_id, $arDelBtn, $arUpdateBtn, $arNewBtn, $arDelDev, $max_btn_id) === false) {
			return URCValues::FUNC_RET_FALSE;
		}

		if(count($arDelDev) > 0)
			return URCValues::FUNC_RET_FALSE;

		/*
		foreach($arUpdateBtn as $btn) {
			$arDelBtn[] = $btn->id;
			$arNewBtn[] = $btn;
		}
		$arUpdateBtn = array();
		*/

		try
		{
			DB::begintransaction();

			//delete
			if(count($arDelBtn) > 0) {

				DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
					where('room_id', '=', $this->roomId)->
					whereIn('id', $arDelBtn)->delete();
			}

			if(count($arDelDev) > 0) {

				//delete buttons in the deleted devices
				DB::table('a_t_btns')->where('room_id', '=', $this->roomId)->
					whereIn('device_id', $arDelDev)->delete();
				//delete devices						
				DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
					whereIn('id', $arDelDev)->delete();
			}

			//update
			if(count($arUpdateBtn) > 0) {

				$query = $this->updateBtnsQuery($arUpdateBtn);
				DB::statement($query);

				/*
				foreach($arUpdateBtn as $btn) {

					DB::table('a_t_btns')->where('device_id', '=', $deviceId)-> 
						where('room_id', '=', $this->roomId)->
						where('id', '=', $btn->id)->
						update(array('page_id' => $btn->page_id, 'page_btn_idx' => $btn->page_btn_idx, 
							'display_text' => $btn->display_text, 'hidden_option' => $btn->hidden_option, 'image_name' => $btn->image_name, 
							'auto_wait' => $btn->auto_wait, 'edit_type' => $btn->edit_type, 'popup' => $btn->popup, 'activity' => $btn->activity, 'macro' => $btn->macro,
							'hidden' => $btn->hidden, 'page_hidden' => $btn->page_hidden));
				}
				*/
			}

			//add
			if(count($arNewBtn) > 0) {
				
				$query = array();

				$urcBtn = new URCTBtnData($this->roomId, $deviceId);
				
				foreach($arNewBtn as $btn) {

					if($btn->page_id < 0) {
						$query[] = $urcBtn->newBtnQueryDetail($btn->id, $btn->page_id, $btn->page_btn_idx, $btn->display_text, $btn->hidden_option, 
							$btn->auto_wait, $btn->edit_type, $btn->popup, $btn->activity, $btn->macro, $btn->hidden, $btn->page_hidden);
					}
					else {
						$query[] = $urcBtn->newBtnQueryDetail($btn->id, $btn->page_id, $btn->page_btn_idx, $btn->display_text, $btn->hidden_option, 
							$btn->auto_wait, $btn->edit_type, $btn->popup, $btn->activity, $btn->macro, $btn->hidden, $btn->page_hidden);
						//$btn_id_start++;
					}

					if($max_btn_id < $btn->id) {
						$max_btn_id = $btn->id;
					}				
				}

				DB::table('a_t_btns')->insert($query);

				//set new btn id
				$max_btn_id++;
				$urcBtn->setNewBtnId($max_btn_id);
			}

			//apply new page id
			$urcPage = new URCTPageData($this->roomId, $deviceId);
			$urcPage->setNewPageId($new_page_id);
			
			//update new DB
			
			//ConDB
			DB::table('a_t_con_db')->where('device_id', '=', $deviceId)-> 
				where('room_id', '=', $this->roomId)->delete();

			$query = array();
			foreach($device->dbCon as $func) {
				
				if(!isset($func->custom) || $func->custom !== 1) {
					$query[] = array('id' => (int) $func->id, 'device_id' => $deviceId, 'room_id' => $this->roomId, 
						'name' => $func->name, 'type' => $func->type, 'data' => $func->data, 'custom' => 0);
				}
				else {
					$query[] = array('id' => (int) $func->id, 'device_id' => $deviceId, 'room_id' => $this->roomId, 
						'name' => $func->name, 'type' => $func->type, 'data' => $func->data,
						'custom' => 1, 'repeat_min' => $func->repeat_min, 'repeat_macro' => $func->repeat_macro);
				}
			}

			if(count($query) > 0) {
				DB::table('a_t_con_db')->insert($query);
			}

			//ErrorDebug::write('aa');
			//Key DB
			DB::table('a_t_keys_db')->where('device_id', '=', $deviceId)-> 
				where('room_id', '=', $this->roomId)->delete();

			$query = array();
			foreach($device->dbKey as $func) {
				
				if(!isset($func->custom) || $func->custom !== 1) {
					$query[] = array('id' => $func->id, 'device_id' => $deviceId, 'room_id' => $this->roomId, 
						'name' => $func->name, 'type' => $func->type, 'data' => $func->data, 'custom' => 0);
				}
				else {
					$query[] = array('id' => $func->id, 'device_id' => $deviceId, 'room_id' => $this->roomId, 
						'name' => $func->name, 'type' => $func->type, 'data' => $func->data,
						'custom' => 1, 'repeat_min' => $func->repeat_min, 'repeat_macro' => $func->repeat_macro);
				}
			}

			//ErrorDebug::write('aa1');
			

			if(count($query) > 0) {
				DB::table('a_t_keys_db')->insert($query);
			}

			//remain setting
			$metaPwrOn = -1;
			$metaPwrOff = -1;
			$metaPwrToggle = -1;
			$metaInToggle = -1;
			if(isset($device->meta_pwr_on)) {
				$metaPwrOn = $device->meta_pwr_on;
			}
			if(isset($device->meta_pwr_off)) {
				$metaPwrOff = $device->meta_pwr_off;
			}
			if(isset($device->meta_pwr_toggle)) {
				$metaPwrToggle = $device->meta_pwr_toggle;
			}
			if(isset($device->meta_in_toggle)) {
				$metaInToggle = $device->meta_in_toggle;
			}
			if($device->type == URCValues::DB_TYPE_IP ||
				$device->type == URCValues::DB_TYPE_UDP) {

				DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
 					where('id', '=', $deviceId)->update(array('repeat_min' => $device->repeat->min, 'repeat_macro' => $device->repeat->macro,
 						'ramp_start' => $device->ramp->start, 'ramp_speed' => $device->ramp->speed, 'con_time' => $device->attr->con_time, 'auto_cr' => $device->attr->auto_cr,
 						'meta_pwr_on' => $metaPwrOn, 'meta_pwr_off' => $metaPwrOff, 'meta_pwr_toggle' => $metaPwrToggle, 'meta_in_toggle' => $metaInToggle));
			}
			else {
 			
 				DB::table('a_t_devices')->where('room_id', '=', $this->roomId)->
 					where('id', '=', $deviceId)->update(array('repeat_min' => $device->repeat->min, 'repeat_macro' => $device->repeat->macro,
 						'meta_pwr_on' => $metaPwrOn, 'meta_pwr_off' => $metaPwrOff, 'meta_pwr_toggle' => $metaPwrToggle, 'meta_in_toggle' => $metaInToggle));
 			}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;
		}

		return URCValues::FUNC_RET_TRUE;
	}
}

class URCTScheEventData {

	var $dealerId = -1;
	var $roomId = -1;

	function __construct($dealerId, $roomId) {	
		$this->dealerId = $dealerId;
		$this->roomId = $roomId;
	}

	protected function getNewEventId() {
		
		$room = DB::table('a_t_rooms')->where('id', '=', $this->roomId)->first();
		if(!$room) {
			return -1;
		}

		//ErrorDebug::write('getnew event id');
		//ErrorDebug::write($room->event_id_start);

		return $room->event_id_start;
	}

	public function setNewEventId($newEventId) {

		//ErrorDebug::write('setnew event id');
		//ErrorDebug::write($newEventId);

		DB::table('a_t_rooms')->where('id', '=', $this->roomId)->update(array('event_id_start' => $newEventId));
	}

	protected function isExistEvent($eventId) {

		$existDB = DB::table('a_t_events')->where('id', '=', $eventId)->
			where('room_id', '=', $this->roomId)->first(); 
		if($existDB) {
			return 1;
		}
		return 0;
	}

	public function getEvents() {

		$chkExisting = DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
			orderBy('order', 'asc')->get();
		foreach($chkExisting as $roomChk) {

			unset($chkExisting->room_id);
			unset($chkExisting->order);
		}

		return $chkExisting;
	}

	public function storeEvents(&$data) {

		$jsonData = json_encode($data);

		//ErrorDebug::write('storeEvents');
		//ErrorDebug::write($jsonData);
		
		$events = json_decode($jsonData);

		$count = count($events);
		if($count <= 0) {
			return URCValues::FUNC_RET_TRUE;
		}

		try
		{
			DB::begintransaction();

			$idx = 0;
			foreach($events as $item) {

				$hidden = 0;
				if(isset($item->hidden)) {
					$hidden = $item->hidden;
				}
				DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
					where('id', '=', $item->id)->update(array('image_name' => $item->image_name,
					'display_text' => $item->display_text, 'hidden_option' => $item->hidden_option,
					'macro' => $item->macro, 'hidden' => $hidden, 'default_state' => $item->default_state, 
					'option' => $item->option, 'day_week' => $item->day_week, 'time' => $item->time, 'order' => $idx));

				$idx++;
			}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;				
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function getEvent($id) {
		
		$chkExisting = DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
			where('id', '=', $id)->first();

		if($chkExisting) {

			unset($chkExisting->room_id);
			return $chkExisting;

		}

		return false;
	}

	public function delEvent($id) {

		try
		{		
			$chkExisting = DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
				where('id', '=', $id)->delete();
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;		
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function createEvent($text, $imageName, $macro, $defaultState, $option, $dayWeek, $time) {

		$jsonMacro = json_encode($macro);
		
		$eventId = $this->getNewEventId();
		if($eventId < 0)
			return URCValues::FUNC_RET_FALSE;		
		//check already exist
		if($this->isExistEvent($eventId))
			return URCValues::FUNC_RET_FALSE;

		try
		{
			DB::begintransaction();
			
			$this->setNewEventId($eventId+1);
		
			DB::table('a_t_events')->insert(array('id' => $eventId, 'room_id' => $this->roomId, 'image_name' => $imageName, 'display_text' => $text, 
				'macro' => $jsonMacro, 'default_state' => $defaultState, 
				'option' => $option, 'day_week' => $dayWeek, 'time' => $time, 'order' => $eventId));
			
			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();
			
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;		
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function setEvent($id, $text, $imageName, $macro, $defaultState, $option, $dayWeek, $time) {

		$jsonMacro = json_encode($macro);

		try
		{
			DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
				where('id', '=', $id)->
				update(array('image_name' => $imageName, 'display_text' => $text, 
				'macro' => $jsonMacro, 'default_state' => $defaultState, 
				'option' => $option, 'day_week' => $dayWeek, 'time' => $time));
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;		
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function updateEventTime($id, $dayWeek, $time) {

		DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
			where('id', '=', $id)->
			update(array('day_week' => $dayWeek, 'time' => $time));
		
		return true;
	}

	public function setEventStatus($id, $defaultState) {
		
		try
		{
			DB::table('a_t_events')->where('room_id', '=', $this->roomId)->
				where('id', '=', $id)->
				update(array('default_state' => $defaultState));
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;		
		}

		return URCValues::FUNC_RET_TRUE;
	}
}

class URCTRoomData {

	var $dealerId = -1;

	function __construct($dealerId) {	
		$this->dealerId = $dealerId;
	}

	public function isOverRoomCount() {
		
		$rooms = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->get();
		if(count($rooms) >= URCValues::MAX_TEMPLATE_CNT)
			return true;

		return false;
	}

	public static function isValidRoom($dealerId, $roomId) {
		
		$room = DB::table('a_t_rooms')->where('id', '=', $roomId)->where('owner', '=', $dealerId)->first();
		if(!$room) {
			return false;
		}

		return true;
	}

	//return : new room id
	public function createRoom($roomName, $table_hdr, &$roomId){

		$roomId = -1;
		try
		{
			DB::begintransaction();

			$roomId = $this->newRoom($roomName);
			if($roomId < 0) {
				throw new \Exception('Room ID not created');
			}
			
			$urcDev = new URCTDeviceData($roomId);
			$deviceId = $urcDev->newMainDevice();
			if($deviceId < 0) {
				throw new \Exception('Device ID not created');
			}

			//set Main Device ID
			if($this->setMainDeviceId($roomId, $deviceId) == false) {
				throw new \Exception('fail to set the Main device id');
			}
			
			//system button
			$urcBtn = new URCTBtnData($roomId, -1);
			$urcBtn->newSystemOffBtn();

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;	
	}

	public function destroyRoom($roomId) {

		try
		{
			DB::begintransaction();

			$this->deleteRoom($roomId);
			
			DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
				where('id', '=', $roomId)->delete();

			//DB::table('a_download')->where('system_id', '=', $this->systemId)->
			//	where('id', '=', $roomId)->delete();

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}
	
	public function editRoom($roomId, $name) {
	
		$updatedRow = 0;

		try
		{
			$updatedRow = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
				where('id', '=', $roomId)->update(array('name' => $name));
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		if($updatedRow <= 0)
			return URCValues::FUNC_RET_FALSE;
		
		return URCValues::FUNC_RET_TRUE;
	}

	public function getRoom($roomId) {
		
		$room = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
			where('id', '=', $roomId)->first();
		if(!$room)
			return false;
		
		$roomObj = new stdClass;

		$roomObj->name = $room->name;
		$roomObj->id = $room->id;
		//$roomObj->bstation = $room->bstation;

		//schedule event
		$roomObj->scheEvent = array();
		$events = DB::table('a_t_events')->where('room_id', '=', $room->id)->
			orderBy('order', 'asc')->get();
		$lenEvent = 0;
		if($events) $lenEvent = count($events);

		for($i2 = 0; $i2 < $lenEvent; $i2++) {

			$roomObj->scheEvent[$i2] = $events[$i2];
			unset($roomObj->scheEvent[$i2]->room_id);
		}

		//devices		
		$roomObj->devices = array();

		$devices = DB::table('a_t_devices')->where('room_id', '=', $room->id)->
			whereNotIn('id', array($room->main_device_id))->get();//not needed system(please delete system_id in the a_devices)

		//gather room condev
		$urcRoomConDB = DB::table('a_t_con_db')->where('room_id', '=', $roomId)->get();

		$urcDev = new URCTDeviceData($roomId);

		$lenDev = 0;
		if($devices) $lenDev = count($devices);
		for($i2 = 0; $i2 < $lenDev; $i2++) {

			//$roomObj->devices[$i2] = new stdClass;

			$devices[$i2]->exist_vol = URCTDeviceData::isExistVol($devices[$i2]);

			$roomObj->devices[$i2] = $devices[$i2];
			unset($roomObj->devices[$i2]->room_id);
			unset($roomObj->devices[$i2]->page_id_start);
			unset($roomObj->devices[$i2]->btn_id_start);

			$deviceId = $roomObj->devices[$i2]->id;			
			$urcConDB = array();//$urcDev->getConDevData($roomObj->devices[$i2]->id);
			foreach($urcRoomConDB as &$func) {

				if($func->device_id != $deviceId) { continue; }
				//unset($func->data);
				//unset($func->device_id);
				unset($func->room_id);
				
				if($func->custom !== 1) {
					unset($func->press_hold);
					unset($func->repeat_min);
					unset($func->repeat_macro);
				}
				unset($func->custom);

				$urcConDB[] = $func;
			}

			$roomObj->devices[$i2]->funcs = $urcConDB;

			//variables
			$roomObj->variables = $this->getVariables($room->id);
		}
		
		return $roomObj;
	}

	public function getRoom_old($roomId) {
		
		$room = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
			where('id', '=', $roomId)->first();
		if(!$room)
			return false;
		
		$roomObj = new stdClass;

		$roomObj->name = $room->name;
		$roomObj->id = $room->id;
		//$roomObj->bstation = $room->bstation;

		//schedule event
		$roomObj->scheEvent = array();
		$events = DB::table('a_t_events')->where('room_id', '=', $room->id)->
			orderBy('order', 'asc')->get();
		$lenEvent = 0;
		if($events) $lenEvent = count($events);

		for($i2 = 0; $i2 < $lenEvent; $i2++) {

			$roomObj->scheEvent[$i2] = $events[$i2];
			unset($roomObj->scheEvent[$i2]->room_id);
		}


		//devices		
		$roomObj->devices = array();

		$devices = DB::table('a_t_devices')->where('room_id', '=', $room->id)->
			whereNotIn('id', array($room->main_device_id))->get();//not needed system(please delete system_id in the a_devices)

		$urcDev = new URCTDeviceData($roomId);

		$lenDev = 0;
		if($devices) $lenDev = count($devices);
		for($i2 = 0; $i2 < $lenDev; $i2++) {

			//$roomObj->devices[$i2] = new stdClass;

			$devices[$i2]->exist_vol = URCTDeviceData::isExistVol($devices[$i2]);

			$roomObj->devices[$i2] = $devices[$i2];
			unset($roomObj->devices[$i2]->room_id);
			unset($roomObj->devices[$i2]->page_id_start);
			unset($roomObj->devices[$i2]->btn_id_start);

			$urcConDB = $urcDev->getConDevData($roomObj->devices[$i2]->id);
			foreach($urcConDB as &$func) {
				//unset($func->data);
				unset($func->device_id);
				unset($func->room_id);
				
				if($func->custom !== 1) {
					unset($func->press_hold);
					unset($func->repeat_min);
					unset($func->repeat_macro);
				}
				unset($func->custom);
			}

			$roomObj->devices[$i2]->funcs = $urcConDB;

			//variables
			$roomObj->variables = $this->getVariables($room->id);
		}
		
		return $roomObj;
	}

	public function getVariables($roomId) {
		
		$vars = DB::table('a_t_variables')->where('room_id', '=', $roomId)->orderBy('name', 'asc')->get();
		foreach($vars as $var) {
			unset($var->roomId);
		}
		return $vars;
	}

	public function addVariable($roomId, $name, $type, $value, &$errMsg, &$retVarId) {

		$room = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
			where('id', '=', $roomId)->first();
		if(!$room)  {
			$errMsg = "can't find the template";
			return URCValues::FUNC_RET_FALSE;
		}		
		
		$existingVar = DB::table('a_t_variables')->where('room_id', '=', $roomId)->where('name', '=', $name)->first();
		if($existingVar) {
			$errMsg = "already existing variable";
			return URCValues::FUNC_RET_FALSE;
		}
		
		$retVarId = 0;

		try
		{
			DB::begintransaction();
			
			$varMax = DB::table('a_t_variables')->where('room_id', '=', $roomId)->orderBy('id', 'desc')->first();
			if($varMax) {
				$retVarId = $varMax->id + 1;
			}

			DB::table('a_t_variables')->insert(array('id' => $retVarId, 'room_id' => $roomId, 'name' => $name, 'type' => $type, 'value' => $value));

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			$errMsg = "db error";
			
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;	
	}

	public function delVariables($roomId, $varId) {
		
		try
		{
			DB::table('a_t_variables')->where('room_id', '=', $roomId)->where('id', '=', $varId)->delete();
		}
		catch(\Exception $e) 
		{
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function setVariable($roomId, $varId, $name, $type, $value, $errMsg) {

		$existingVar = DB::table('a_t_variables')->where('room_id', '=', $roomId)->where('name', '=', $name)->first();
		if(!$existingVar) {
			$errMsg = "not existing variable";
			return URCValues::FUNC_RET_FALSE;
		}

		try
		{
			DB::table('a_t_variables')->where('id', '=', $varId)->update(array('room_id' => $roomId, 'name' => $name, 'type' => $type, 'value' => $value));
		}
		catch(\Exception $e) 
		{
			$errMsg = "DB Error";
			
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function getDevices($roomId) {

		$devices = DB::table('a_t_devices')->where('room_id', '=', $roomId)->get();
		if(!$devices)
			return false;
		
		return json_encode($devices);
	}


	public function getConDevs($roomId) {
		$condevs = DB::table('a_t_con_db')->where('room_id', '=', $roomId)->get();
		if(!$condevs)
			return false;
		
		return json_encode($condevs);
	}

	public function newRoom($roomName) {

		$roomId = DB::table('a_t_rooms')->insertGetId(array('owner' => $this->dealerId, 'device_id_start' => 0, 
				'name' => $roomName, 'created_at' => date('Y-m-d H:i:s')));

		return $roomId;
	}

	public function setMainDeviceId($roomId, $mainDeviceId) {

		$updateRow = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
			where('id', '=', $roomId)->update(array('main_device_id' => $mainDeviceId));
		
		if($updateRow <= 0)
			return false;

		return true;
	}

	public function deleteRoom($roomId) {

		DB::table('a_t_devices')->where('room_id', '=', $roomId)->delete();
		DB::table('a_t_keys_db')->where('room_id', '=', $roomId)->delete();
		DB::table('a_t_con_db')->where('room_id', '=', $roomId)->delete();
		//DB::table('a_pages')->where('room_id', '=', $roomId)->delete();
		DB::table('a_t_btns')->where('room_id', '=', $roomId)->delete();

		DB::table('a_t_events')->where('room_id', '=', $roomId)->delete();
		DB::table('a_t_variables')->where('room_id', '=', $roomId)->delete();
	}
}



class URCTemplateData {

	var $dealerGrpId = -1;
	var $dealerId = -1;

	function __construct($dealerGrpId, $dealerId) {	
		$this->dealerGrpId = $dealerGrpId;
		$this->dealerId = $dealerId;
	}


	public function getTemplateList() {

		$urcDevices = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->
			select('id', 'created_at', 'name')->get(); 

		return $urcDevices;
	}

	public function save($systemId, $roomId, $name, &$errMsg) {
	
		$room = DB::table('a_rooms')->where('id', '=', $roomId)->first();
		if(!$room) 
			return URCValues::FUNC_RET_FALSE;

				
		try
		{
			DB::begintransaction();

			$urcEvents = DB::table('a_events')->where('room_id', '=', $roomId)->get();
			$urcDevices = DB::table('a_devices')->where('room_id', '=', $roomId)->get();
			$urcBtns = DB::table('a_btns')->where('room_id', '=', $roomId)->get();
			$urcConDB = DB::table('a_con_db')->where('room_id', '=', $roomId)->get();
			$urcKeyDB = DB::table('a_keys_db')->where('room_id', '=', $roomId)->get();
			$urcVars = DB::table('a_variables')->where('system_id', '=', $systemId)->get();
			
			//room
			unset($room->id);
			unset($room->system_id);
			$room->name = $name;
			$room->owner = $this->dealerId;
			$room->created_at = date('Y-m-d H:i:s');
			$tRoomId = DB::table('a_t_rooms')->insertGetId((array)$room);
			//schedule event
			if(count($urcEvents) > 0) {
				$addedItems = array();
				foreach($urcEvents as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;					
				}
				DB::table('a_t_events')->insert($addedItems);
			}
			
			//devices		
			if(count($urcDevices) > 0) {
				$addedItems = array();
				foreach($urcDevices as $item) {
					$item->room_id = $tRoomId;
					$item->target_addr = '';
					$addedItems[] = (array)$item;					
				}
				DB::table('a_t_devices')->insert($addedItems);
			}

			//buttons
			if(count($urcBtns) > 0) {
				$addedItems = array();
				foreach($urcBtns as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;					
				}
				DB::table('a_t_btns')->insert($addedItems);
			}

			//con dev
			if(count($urcConDB) > 0) {
				$addedItems = array();
				foreach($urcConDB as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;
				}
				DB::table('a_t_con_db')->insert($addedItems);
			}

			//key
			if(count($urcKeyDB) > 0) {
				$addedItems = array();
				foreach($urcKeyDB as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;
				}
				DB::table('a_t_keys_db')->insert($addedItems);
			}

			//variables
			if(count($urcVars) > 0) {
				$addedItems = array();
				foreach($urcVars as $item) {
					unset($item->system_id);
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;
				}

				//ErrorDebug::write(json_encode($addedItems));
				DB::table('a_t_variables')->insert($addedItems);
			}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			//ErrorDebug::write($e->getMessage());
			if(strlen($errMsg) <= 0) {
				$errMsg = "can't create template";
			}

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function copyFromTemplate($tRoomId, $roomId, &$errMsg) {
	
		$room = DB::table('a_t_rooms')->where('id', '=', $roomId)->first();
		if(!$room) {
			$errMsg = "can't find template";
			return URCValues::FUNC_RET_FALSE;
		}

		try
		{
			DB::begintransaction();

			$urcTRoom = new URCTRoomData($this->dealerId);
			$urcTRoom->deleteRoom($tRoomId);

			//room
			/*
			unset($room->id);
			unset($room->system_id);
			$room->name = $name;
			$room->owner = $this->dealerId;
			$room->created_at = date('Y-m-d H:i:s');
			$tRoomId = DB::table('a_t_rooms')->insertGetId((array)$room);
			*/
			DB::table('a_t_rooms')->where('id', '=', $tRoomId)->
				update(array('device_id_start' => $room->device_id_start, 
					'main_device_id' => $room->main_device_id,
					'event_id_start' => $room->event_id_start));

			//schedule event
			$urcEvents = DB::table('a_t_events')->where('room_id', '=', $roomId)->get();
			if(count($urcEvents) > 0) {
				$addedItems = array();
				foreach($urcEvents as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;					
				}
				DB::table('a_t_events')->insert($addedItems);
			}
			
			//devices		
			$urcDevices = DB::table('a_t_devices')->where('room_id', '=', $roomId)->get();
			if(count($urcDevices) > 0) {
				$addedItems = array();
				foreach($urcDevices as $item) {
					$item->room_id = $tRoomId;
					$item->target_addr = '';
					$addedItems[] = (array)$item;					
				}
				DB::table('a_t_devices')->insert($addedItems);
			}

			//buttons
			$urcBtns = DB::table('a_t_btns')->where('room_id', '=', $roomId)->get();
			if(count($urcBtns) > 0) {
				$addedItems = array();
				foreach($urcBtns as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;					
				}
				DB::table('a_t_btns')->insert($addedItems);
			}

			//con dev
			$urcConDB = DB::table('a_t_con_db')->where('room_id', '=', $roomId)->get();
			if(count($urcConDB) > 0) {
				$addedItems = array();
				foreach($urcConDB as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;
				}
				DB::table('a_t_con_db')->insert($addedItems);
			}

			//key
			$urcKeyDB = DB::table('a_t_keys_db')->where('room_id', '=', $roomId)->get();
			if(count($urcKeyDB) > 0) {
				$addedItems = array();
				foreach($urcKeyDB as $item) {
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;
				}
				DB::table('a_t_keys_db')->insert($addedItems);
			}

			//variables
			$urcVars = DB::table('a_t_variables')->where('room_id', '=', $roomId)->get();
			if(count($urcVars) > 0) {
				$addedItems = array();
				foreach($urcVars as $item) {
					//unset($item->system_id);
					$item->room_id = $tRoomId;
					$addedItems[] = (array)$item;
				}

				//ErrorDebug::write(json_encode($addedItems));
				DB::table('a_t_variables')->insert($addedItems);
			}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			//ErrorDebug::write($e->getMessage());
			if(strlen($errMsg) <= 0) {
				$errMsg = "can't create template";
			}

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function applyNew($tRoomId, $systemId, $bstationType, $bstationName, $bstationMac, $roomName, &$errMsg) {

		$tRoom = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->where('id', '=', $tRoomId)->first();
		if(!$tRoom) {
			$errMsg = "can't find template";
			return URCValues::FUNC_RET_FALSE;
		}	

		if(!URCSystemData::isValidSystemForDealer($this->dealerGrpId, $systemId)) {
			$errMsg = "not valid for this dealer";
			return URCValues::FUNC_RET_FALSE;
		}


		try
		{
			DB::begintransaction();

			$master = 0;
			//room
			$roomId = $this->createRoomInfo($tRoom, $systemId, $master, $bstationType, $bstationName, $bstationMac,  $roomName);
			if($roomId < 0) {
				$errMsg = "copy dev info error";
				throw new \Exception($errMsg);
			}				

			$this->copyInsideRoom($tRoomId, $systemId, $roomId, $tRoom->apply_cnt);

			DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->where('id', '=', $tRoomId)->
				update(array('apply_cnt' => ((int)$tRoom->apply_cnt) + 1));

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			$errMsg = $e->getMessage();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}

	public function applyExisting($tRoomId, $roomId, $name, &$errMsg) {

		$tRoom = DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->where('id', '=', $tRoomId)->first();
		if(!$tRoom) {
			$errMsg = "can't find template";
			return URCValues::FUNC_RET_FALSE;
		}	

		if(!URCSystemData::isValidRoomForDealer2($this->dealerGrpId, $roomId, $system, $room)) {
			$errMsg = "not valid for this dealer";
			return URCValues::FUNC_RET_FALSE;
		}
		
		try
		{
			DB::begintransaction();

			//room
			$roomId = $this->copyRoomInfo($tRoom, $room->system_id, $roomId);
			if($roomId < 0) {
				$errMsg = "copy dev info error";
				throw new \Exception($errMsg);
			}

			$this->copyInsideRoom($tRoomId, $room->system_id, $roomId, $tRoom->apply_cnt);

			DB::table('a_t_rooms')->where('owner', '=', $this->dealerId)->where('id', '=', $tRoomId)->
				update(array('apply_cnt' => ((int)$tRoom->apply_cnt) + 1));

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			$errMsg = $e->getMessage();

			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}
			return URCValues::FUNC_RET_FALSE;	
		}

		return URCValues::FUNC_RET_TRUE;
	}
	
	protected function createRoomInfo(&$tRoom, $systemId, $master, $bstationType, $bstationName, $bstationMac, $roomName) {

		$urcRoom = new URCRoomData($systemId);
		$roomId = $urcRoom->newRoom($master, $bstationType, $bstationName, $bstationMac, $roomName);
		if($roomId < 0) {
			throw new \Exception('Room ID not created');
			return -1;
		}

		DB::table('a_rooms')->where('system_id', '=', $systemId)->where('id', '=', $roomId)->
			update(array('device_id_start' => $tRoom->device_id_start,
			'main_device_id' => $tRoom->main_device_id, 'event_id_start' => $tRoom->event_id_start));
		
		return $roomId;
	}

	protected function copyRoomInfo(&$tRoom, $systemId, $roomId) {

		//delete existing
		DB::table('a_devices')->where('room_id', '=', $roomId)->delete();
		DB::table('a_keys_db')->where('room_id', '=', $roomId)->delete();
		DB::table('a_con_db')->where('room_id', '=', $roomId)->delete();
		DB::table('a_btns')->where('room_id', '=', $roomId)->delete();
		DB::table('a_twoway_devices')->where('room_id', '=', $roomId)->delete();
		DB::table('a_events')->where('room_id', '=', $roomId)->delete();

		//remote bstation will be kept
		//DB::table('a_remotes')->where('room_id', '=', $roomId)->delete();
		//DB::table('a_bstations')->where('room_id', '=', $roomId)->delete();
		

		DB::table('a_rooms')->where('system_id', '=', $systemId)->where('id', '=', $roomId)->
			update(array('device_id_start' => $tRoom->device_id_start,
			'main_device_id' => $tRoom->main_device_id, 'event_id_start' => $tRoom->event_id_start));
		
		return $roomId;
	}

	protected function calcNewVar(&$arOrgVarId, &$arNewVarId, $orgVarId) {

		$varCnt = count($arOrgVarId);

		for($i = 0; $i < $varCnt; $i++) {
			if($arOrgVarId[$i] === $orgVarId) {
				return $arNewVarId[$i];
			}
		}

		return false;
	}

	protected function calcMacroVars(&$arOrgVarId, &$arNewVarId, &$macroObj) {

		
		$cnt = count($macroObj);
		if($cnt <= 0) {
			return false;
		}

		$ret = false;
		for($i = 0; $i < $cnt; $i++) {
			switch($macroObj[$i]->type)
			{
			case 4://if
				if($macroObj[$i]->cond->type === 1) {
					
					$newVarId = $this->calcNewVar($arOrgVarId, $arNewVarId, $macroObj[$i]->cond->id);
					if($newVarId !== false) {
						$macroObj[$i]->cond->id = $newVarId;
						$ret = true;
					}

					if($this->calcMacroVars($arOrgVarId, $arNewVarId, $macroObj[$i]->true) === true) {
						$ret = true;
					}

					if($this->calcMacroVars($arOrgVarId, $arNewVarId, $macroObj[$i]->false) === true) {
						$ret = true;
					}
				}
				break;
			case 5://var
				$newVarId = $this->calcNewVar($arOrgVarId, $arNewVarId, $macroObj[$i]->id);
				if($newVarId !== false) {
					$macroObj[$i]->id = $newVarId;
					$ret = true;
				}
				break;
			}
		}

		return $ret;
	}

	protected function copyInsideRoom($tRoomId, $systemId, $roomId, $varSufix) {

		$bstation = DB::table('a_bstations')->where('system_id', '=', $systemId)->where('room_id', '=', $roomId)->first();
		
		//schedule event
		$tEvents = DB::table('a_t_events')->where('room_id', '=', $tRoomId)->get();
		if(count($tEvents) > 0) {
			$addedItems = array();
			foreach($tEvents as $item) {
				$item->room_id = $roomId;
				$addedItems[] = (array)$item;					
			}
			DB::table('a_events')->insert($addedItems);
		}
		
		//devices		
		$tDevices = DB::table('a_t_devices')->where('room_id', '=', $tRoomId)->get();
		if(count($tDevices) > 0) {
			$addedItems = array();
			foreach($tDevices as $item) {
				$item->room_id = $roomId;
				if($bstation && (($item->target_type & 0xffff) == URCValues::DB_TYPE_IR)) {
					$item->target_addr = $bstation->mac;
				}
				else {
					$item->target_addr = '';
				}
				$addedItems[] = (array)$item;					
			}
			DB::table('a_devices')->insert($addedItems);
		}

		//con dev
		$tConDB = DB::table('a_t_con_db')->where('room_id', '=', $tRoomId)->get();
		if(count($tConDB) > 0) {
			$addedItems = array();
			foreach($tConDB as $item) {
				$item->room_id = $roomId;
				$addedItems[] = (array)$item;
			}
			DB::table('a_con_db')->insert($addedItems);
		}

		//key
		$tKeyDB = DB::table('a_t_keys_db')->where('room_id', '=', $tRoomId)->get();
		if(count($tKeyDB) > 0) {
			$addedItems = array();
			foreach($tKeyDB as $item) {
				$item->room_id = $roomId;
				$addedItems[] = (array)$item;
			}
			DB::table('a_keys_db')->insert($addedItems);
		}

		//what should we do for variables?

		$tVars = DB::table('a_t_variables')->where('room_id', '=', $tRoomId)->get();
		$existingVars = DB::table('a_variables')->where('system_id', '=', $systemId)->get();
		if(count($existingVars) > 0 && count($tVars) > 0) {

			$system = DB::table('a_systems')->where('id', '=', $systemId)->first();

			//max template var
			$varTMax = 0;
			$varTMaxItem = DB::table('a_t_variables')->where('room_id', '=', $tRoomId)->orderBy('id', 'desc')->first();
			if(!$varTMaxItem) {
				$varTMax = 0;
			}
			else {
				$varTMax = $varTMaxItem->id + 1;
			}

			//system start value
			if($varTMax > $system->var_id_start) {
				$system->var_id_start = $varTMax;
			}
		
			//variables
			$arOrgVarId = array();
			$arNewVarId = array();
		
			$addedItems = array();
			foreach($tVars as $item) {

				$arOrgVarId[] = $item->id;
				$arNewVarId[] = $system->var_id_start;
		
				unset($item->room_id);
				$item->system_id = $systemId;
				$newVarName = substr($item->name.'_'.$varSufix, 0, URCValues::MAX_TEMPLATE_VAR_NAME);
				$item->name = $newVarName;
				$item->id = $system->var_id_start;
				$addedItems[] = (array)$item;
		
				$system->var_id_start++;
			}
			DB::table('a_variables')->insert($addedItems);
		
			DB::table('a_systems')->where('id', '=', $systemId)->update(array('var_id_start' => $system->var_id_start));
		
			//btns
			$tBtns = DB::table('a_t_btns')->where('room_id', '=', $tRoomId)->get();
			if(count($tBtns) > 0) {
				$addedItems = array();
				foreach($tBtns as $item) {
					$item->room_id = $roomId;
					$macroObj = json_decode($item->macro);
					if($this->calcMacroVars($arOrgVarId, $arNewVarId, $macroObj) === true) {
						$item->macro = json_encode($macroObj);
					}
					
					$addedItems[] = (array)$item;
				}
				DB::table('a_btns')->insert($addedItems);
			}

		} 
		else {
		
			//variables
			if(count($tVars) > 0) {

				$max_var_id = 0;
			
				$addedItems = array();
				foreach($tVars as $item) {
					unset($item->room_id);
					$item->system_id = $systemId;
					$newVarName = substr($item->name.'_'.$varSufix, 0, URCValues::MAX_TEMPLATE_VAR_NAME);
					$item->name = $newVarName;
					$addedItems[] = (array)$item;

					if($max_var_id <= $item->id) {
						$max_var_id = $item->id + 1;
					}
				}
				DB::table('a_variables')->insert($addedItems);

				DB::table('a_systems')->where('id', '=', $systemId)->update(array('var_id_start' => $max_var_id));

			}
			
			//btns
			$tBtns = DB::table('a_t_btns')->where('room_id', '=', $tRoomId)->get();
			if(count($tBtns) > 0) {
				$addedItems = array();
				foreach($tBtns as $item) {
					$item->room_id = $roomId;
					$addedItems[] = (array)$item;
				}
				DB::table('a_btns')->insert($addedItems);
			}

		}
	}
}
