<?php

class BaseController extends Controller {

	/**
	 * Setup the layout used by the controller.
	 *
	 * @return void
	 */
	protected function setupLayout()
	{
		if ( ! is_null($this->layout))
		{
			$this->layout = View::make($this->layout);
		}
	}

	var $username = null;
	var $usr_id = -1;
	var $usr_level = -1;
	var $usr = null;

	public function chkJWTTokenWithLevel($level, &$errMsg, &$errNo) {

		$errMsg = '';
		$errNo = -1;
		if(!URCJWTWork::chkJWTToken($this->username, $this->usr_id, $this->usr_level, $errMsg, $errNo)) {
			return false;
		}

		if($this->usr_level !== $level && $this->usr_level < URCValues::LOGIN_ADMIN) {
			return false;
		}
		
		return true;
	}


	public function chkJWTToken(&$errMsg, &$errNo) {

		$errMsg = '';
		$errNo = -1;
		if(!URCJWTWork::chkJWTToken($this->username, $this->usr_id, $this->usr_level, $errMsg, $errNo)) {
			return false;
		}

		return true;
	}

	public function chkUser() {

		$this->usr = null;
		if($this->username == null) {
			return false;
		}

		$editor_type = Config::get('editorenv.editor_type');
		$this->usr = User::where('username', '=', $this->username)->where('editor', '=', $editor_type)->first();

		if($this->usr) {
			return true;
		}

		return false;
	}

	public function chkInstaller() {

		$this->usr = null;
		if($this->username == null) {
			return false;
		}

		$this->usr = Installer::where('username', '=', $this->username)->first();

		if($this->usr) {
			return true;
		}

		return false;
	}
}
